/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.dns.geoscaling;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.Lifecycle;
import brooklyn.entity.basic.ServiceStateLogic;
import brooklyn.entity.dns.AbstractGeoDnsServiceImpl;
import brooklyn.entity.dns.geoscaling.GeoscalingDnsService;
import brooklyn.entity.dns.geoscaling.GeoscalingScriptGenerator;
import brooklyn.entity.dns.geoscaling.GeoscalingWebClient;
import brooklyn.location.geo.HostGeoInfo;
import brooklyn.util.collections.MutableSet;
import brooklyn.util.text.Identifiers;
import brooklyn.util.text.Strings;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Collection;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoscalingDnsServiceImpl
extends AbstractGeoDnsServiceImpl
implements GeoscalingDnsService {
    private static final Logger log = LoggerFactory.getLogger(GeoscalingDnsServiceImpl.class);
    private Set<HostGeoInfo> rememberedTargetHosts;
    private final GeoscalingWebClient webClient = new GeoscalingWebClient();
    private boolean randomizeSmartSubdomainName;
    private String username;
    private String password;
    private String primaryDomainName;
    private String smartSubdomainName;
    boolean isConfigured = false;

    public void init() {
        super.init();
        if (this.getConfig(RANDOMIZE_SUBDOMAIN_NAME) == null) {
            this.setConfig(RANDOMIZE_SUBDOMAIN_NAME, true);
        }
    }

    @Override
    public void onManagementBecomingMaster() {
        try {
            this.applyConfig();
        }
        catch (Exception e) {
            log.error("Geoscaling did not come up correctly: " + e, (Throwable)e);
            ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.ON_FIRE);
        }
        super.onManagementBecomingMaster();
    }

    @Override
    public synchronized void applyConfig() {
        this.randomizeSmartSubdomainName = (Boolean)this.getConfig(RANDOMIZE_SUBDOMAIN_NAME);
        this.username = (String)this.getConfig(GEOSCALING_USERNAME);
        this.password = (String)this.getConfig(GEOSCALING_PASSWORD);
        this.primaryDomainName = (String)this.getConfig(GEOSCALING_PRIMARY_DOMAIN_NAME);
        this.smartSubdomainName = (String)this.getConfig(GEOSCALING_SMART_SUBDOMAIN_NAME);
        Preconditions.checkNotNull((Object)this.username, (Object)"The GeoScaling username is not specified");
        Preconditions.checkNotNull((Object)this.password, (Object)"The GeoScaling password is not specified");
        Preconditions.checkNotNull((Object)this.primaryDomainName, (Object)"The GeoScaling primary domain name is not specified");
        if (this.randomizeSmartSubdomainName) {
            this.smartSubdomainName = this.smartSubdomainName != null ? this.smartSubdomainName + "-" : "";
            this.smartSubdomainName = this.smartSubdomainName + Identifiers.makeRandomId((int)8);
        }
        Preconditions.checkNotNull((Object)this.smartSubdomainName, (Object)"The GeoScaling smart subdomain name is not specified or randomized");
        String fullDomain = this.smartSubdomainName + "." + this.primaryDomainName;
        log.info("GeoScaling service will configure redirection for '" + fullDomain + "' domain");
        this.setAttribute(GEOSCALING_ACCOUNT, this.username);
        this.setAttribute(MANAGED_DOMAIN, fullDomain);
        this.setAttribute(HOSTNAME, this.getHostname());
        this.isConfigured = true;
        if (this.rememberedTargetHosts != null) {
            this.reconfigureService(this.rememberedTargetHosts);
            this.rememberedTargetHosts = null;
        }
    }

    @Override
    public String getHostname() {
        String result = (String)this.getAttribute(MANAGED_DOMAIN);
        return Strings.isBlank((CharSequence)result) ? null : result;
    }

    @Override
    public long getTimeToLiveSeconds() {
        return 300L;
    }

    @Override
    public void destroy() {
        this.setServiceState(Lifecycle.STOPPING);
        if (!this.isConfigured) {
            return;
        }
        if (this.randomizeSmartSubdomainName) {
            GeoscalingWebClient.SmartSubdomain smartSubdomain;
            this.webClient.login(this.username, this.password);
            GeoscalingWebClient.Domain primaryDomain = this.webClient.getPrimaryDomain(this.primaryDomainName);
            GeoscalingWebClient.SmartSubdomain smartSubdomain2 = smartSubdomain = primaryDomain != null ? primaryDomain.getSmartSubdomain(this.smartSubdomainName) : null;
            if (smartSubdomain != null) {
                log.info("Deleting randomized GeoScaling smart subdomain '" + this.smartSubdomainName + "." + this.primaryDomainName + "'");
                smartSubdomain.delete();
            }
            this.webClient.logout();
        }
        super.destroy();
        this.isConfigured = false;
    }

    @Override
    protected void reconfigureService(Collection<HostGeoInfo> targetHosts) {
        if (!this.isConfigured) {
            this.rememberedTargetHosts = MutableSet.copyOf(targetHosts);
            return;
        }
        this.webClient.login(this.username, this.password);
        GeoscalingWebClient.Domain primaryDomain = this.webClient.getPrimaryDomain(this.primaryDomainName);
        if (primaryDomain == null) {
            throw new NullPointerException(this + " got null from web client for primary domain " + this.primaryDomainName);
        }
        GeoscalingWebClient.SmartSubdomain smartSubdomain = primaryDomain.getSmartSubdomain(this.smartSubdomainName);
        if (smartSubdomain == null) {
            log.info("GeoScaling {} smart subdomain '{}.{}' does not exist, creating it now", new Object[]{this, this.smartSubdomainName, this.primaryDomainName});
            primaryDomain.createSmartSubdomain(this.smartSubdomainName);
            smartSubdomain = primaryDomain.getSmartSubdomain(this.smartSubdomainName);
        }
        if (smartSubdomain != null) {
            log.debug("GeoScaling {} being reconfigured to use {}", (Object)this, targetHosts);
            String script = GeoscalingScriptGenerator.generateScriptString(targetHosts);
            smartSubdomain.configure(2L, script);
            if (targetHosts.isEmpty()) {
                this.setServiceState(Lifecycle.CREATED);
                this.setAttribute(ROOT_URL, null);
                this.setAttribute(MAIN_URI, null);
            } else {
                this.setServiceState(Lifecycle.RUNNING);
                String domain = (String)this.getAttribute(MANAGED_DOMAIN);
                if (!Strings.isEmpty((CharSequence)domain)) {
                    this.setAttribute(ROOT_URL, "http://" + domain + "/");
                    this.setAttribute(MAIN_URI, URI.create("http://" + domain + "/"));
                }
            }
        } else {
            log.warn("Failed to retrieve or create GeoScaling smart subdomain '" + this.smartSubdomainName + "." + this.primaryDomainName + "', aborting attempt to configure service");
            this.setServiceState(Lifecycle.ON_FIRE);
        }
        this.webClient.logout();
    }
}

