/*
 * Decompiled with CFR 0.152.
 */
package com.maxmind.geoip2;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.maxmind.db.Reader;
import com.maxmind.geoip2.GeoIp2Provider;
import com.maxmind.geoip2.exception.AddressNotFoundException;
import com.maxmind.geoip2.exception.GeoIp2Exception;
import com.maxmind.geoip2.model.CityIspOrgResponse;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.model.ConnectionTypeResponse;
import com.maxmind.geoip2.model.CountryResponse;
import com.maxmind.geoip2.model.DomainResponse;
import com.maxmind.geoip2.model.InsightsResponse;
import com.maxmind.geoip2.model.IspResponse;
import com.maxmind.geoip2.model.OmniResponse;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;

public class DatabaseReader
implements GeoIp2Provider,
Closeable {
    private final Reader reader;
    private final ObjectMapper om;

    DatabaseReader(Builder builder) throws IOException {
        if (builder.stream != null) {
            this.reader = new Reader(builder.stream);
        } else if (builder.database != null) {
            this.reader = new Reader(builder.database, builder.mode);
        } else {
            throw new IllegalArgumentException("Unsupported Builder configuration: expected either File or URL");
        }
        this.om = new ObjectMapper();
        this.om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.om.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        InjectableValues.Std inject = new InjectableValues.Std().addValue("locales", builder.locales);
        this.om.setInjectableValues((InjectableValues)inject);
    }

    private <T> T get(InetAddress ipAddress, Class<T> cls) throws IOException, AddressNotFoundException {
        return this.get(ipAddress, cls, true);
    }

    private <T> T get(InetAddress ipAddress, Class<T> cls, boolean hasTraits) throws IOException, AddressNotFoundException {
        ObjectNode ipNode;
        ObjectNode node = (ObjectNode)this.reader.get(ipAddress);
        if (node == null) {
            throw new AddressNotFoundException("The address " + ipAddress.getHostAddress() + " is not in the database.");
        }
        if (hasTraits) {
            if (!node.has("traits")) {
                node.put("traits", (JsonNode)this.om.createObjectNode());
            }
            ipNode = (ObjectNode)node.get("traits");
        } else {
            ipNode = node;
        }
        ipNode.put("ip_address", ipAddress.getHostAddress());
        return (T)this.om.treeToValue((TreeNode)node, cls);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public CountryResponse country(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.get(ipAddress, CountryResponse.class);
    }

    @Override
    public CityResponse city(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.get(ipAddress, CityResponse.class);
    }

    @Override
    @Deprecated
    public CityIspOrgResponse cityIspOrg(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.get(ipAddress, CityIspOrgResponse.class);
    }

    @Override
    @Deprecated
    public OmniResponse omni(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.get(ipAddress, OmniResponse.class);
    }

    public InsightsResponse insights(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.get(ipAddress, InsightsResponse.class);
    }

    public ConnectionTypeResponse connectionType(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.get(ipAddress, ConnectionTypeResponse.class, false);
    }

    public DomainResponse domain(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.get(ipAddress, DomainResponse.class, false);
    }

    public IspResponse isp(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.get(ipAddress, IspResponse.class, false);
    }

    public static final class Builder {
        final File database;
        final InputStream stream;
        List<String> locales = Arrays.asList("en");
        Reader.FileMode mode = Reader.FileMode.MEMORY_MAPPED;

        public Builder(InputStream stream) {
            this.stream = stream;
            this.database = null;
        }

        public Builder(File database) {
            this.database = database;
            this.stream = null;
        }

        public Builder locales(List<String> val) {
            this.locales = val;
            return this;
        }

        public Builder fileMode(Reader.FileMode val) {
            if (this.stream != null && !Reader.FileMode.MEMORY.equals((Object)val)) {
                throw new IllegalArgumentException("Only FileMode.MEMORY is supported when using an InputStream.");
            }
            this.mode = val;
            return this;
        }

        public DatabaseReader build() throws IOException {
            return new DatabaseReader(this);
        }
    }
}

