/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PySlice$PyExposer;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

@ExposedType(name="slice", isBaseType=false, doc="slice([start,] stop[, step])\n\nCreate a slice object.  This is used for extended slicing (e.g. a[0:10:2]).")
public class PySlice
extends PyObject {
    public static final PyType TYPE;
    public PyObject start = Py.None;
    public PyObject stop = Py.None;
    public PyObject step = Py.None;

    public PySlice() {
        super(TYPE);
    }

    public PySlice(PyObject start, PyObject stop, PyObject step) {
        super(TYPE);
        if (start != null) {
            this.start = start;
        }
        if (stop != null) {
            this.stop = stop;
        }
        if (step != null) {
            this.step = step;
        }
    }

    @ExposedNew
    static PyObject slice_new(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        if (args.length == 0) {
            throw Py.TypeError("slice expected at least 1 arguments, got " + args.length);
        }
        if (args.length > 3) {
            throw Py.TypeError("slice expected at most 3 arguments, got " + args.length);
        }
        ArgParser ap = new ArgParser("slice", args, keywords, "start", "stop", "step");
        PySlice slice2 = new PySlice();
        if (args.length == 1) {
            slice2.stop = ap.getPyObject(0);
        } else if (args.length == 2) {
            slice2.start = ap.getPyObject(0);
            slice2.stop = ap.getPyObject(1);
        } else if (args.length == 3) {
            slice2.start = ap.getPyObject(0);
            slice2.stop = ap.getPyObject(1);
            slice2.step = ap.getPyObject(2);
        }
        return slice2;
    }

    @Override
    public int hashCode() {
        return this.slice___hash__();
    }

    final int slice___hash__() {
        throw Py.TypeError(String.format("unhashable type: '%.200s'", this.getType().fastGetName()));
    }

    @Override
    public PyObject __eq__(PyObject o) {
        if (this.getType() != o.getType() && !this.getType().isSubType(o.getType())) {
            return null;
        }
        if (this == o) {
            return Py.True;
        }
        PySlice oSlice = (PySlice)o;
        return Py.newBoolean(PySlice.eq(this.getStart(), oSlice.getStart()) && PySlice.eq(this.getStop(), oSlice.getStop()) && PySlice.eq(this.getStep(), oSlice.getStep()));
    }

    private static final boolean eq(PyObject o1, PyObject o2) {
        return o1._cmp(o2) == 0;
    }

    @Override
    public PyObject __ne__(PyObject o) {
        return this.__eq__(o).__not__();
    }

    public PyObject indices(PyObject len) {
        return this.slice_indices(len);
    }

    final PyObject slice_indices(PyObject len) {
        int[] indices = this.indicesEx(len.asIndex(Py.OverflowError));
        return new PyTuple(Py.newInteger(indices[0]), Py.newInteger(indices[1]), Py.newInteger(indices[2]));
    }

    public int[] indicesEx(int len) {
        int stop;
        int start;
        int step;
        if (this.getStep() == Py.None) {
            step = 1;
        } else {
            step = PySlice.calculateSliceIndex(this.getStep());
            if (step == 0) {
                throw Py.ValueError("slice step cannot be zero");
            }
        }
        if (this.getStart() == Py.None) {
            start = step < 0 ? len - 1 : 0;
        } else {
            start = PySlice.calculateSliceIndex(this.getStart());
            if (start < 0) {
                start += len;
            }
            if (start < 0) {
                int n = start = step < 0 ? -1 : 0;
            }
            if (start >= len) {
                int n = start = step < 0 ? len - 1 : len;
            }
        }
        if (this.getStop() == Py.None) {
            stop = step < 0 ? -1 : len;
        } else {
            stop = PySlice.calculateSliceIndex(this.getStop());
            if (stop < 0) {
                stop += len;
            }
            if (stop < 0) {
                stop = -1;
            }
            if (stop > len) {
                stop = len;
            }
        }
        int slicelength = step < 0 && stop >= start || step > 0 && start >= stop ? 0 : (step < 0 ? (stop - start + 1) / step + 1 : (stop - start - 1) / step + 1);
        return new int[]{start, stop, step, slicelength};
    }

    public static PyObject[] indices2(PyObject obj, PyObject start, PyObject stop) {
        int istop;
        int istart;
        PyObject[] indices;
        block5: {
            indices = new PyObject[2];
            istart = start == null || start == Py.None ? 0 : PySlice.calculateSliceIndex(start);
            int n = istop = stop == null || stop == Py.None ? Integer.MAX_VALUE : PySlice.calculateSliceIndex(stop);
            if (istart < 0 || istop < 0) {
                try {
                    int len = obj.__len__();
                    if (istart < 0) {
                        istart += len;
                    }
                    if (istop < 0) {
                        istop += len;
                    }
                }
                catch (PyException pye) {
                    if (pye.match(Py.TypeError)) break block5;
                    throw pye;
                }
            }
        }
        indices[0] = Py.newInteger(istart);
        indices[1] = Py.newInteger(istop);
        return indices;
    }

    public static int calculateSliceIndex(PyObject v) {
        if (v.isIndex()) {
            return v.asIndex();
        }
        throw Py.TypeError("slice indices must be integers or None or have an __index__ method");
    }

    @Override
    public String toString() {
        return this.slice_toString();
    }

    final String slice_toString() {
        return String.format("slice(%s, %s, %s)", this.getStart(), this.getStop(), this.getStep());
    }

    public final PyObject getStart() {
        return this.start;
    }

    public final PyObject getStop() {
        return this.stop;
    }

    public final PyObject getStep() {
        return this.step;
    }

    static {
        PyType.addBuilder(PySlice.class, new PySlice$PyExposer());
        TYPE = PyType.fromClass(PySlice.class);
    }
}

