/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.jclouds.googlecomputeengine.domain.AttachDisk;
import org.jclouds.googlecomputeengine.domain.AutoValue_NewInstance;
import org.jclouds.googlecomputeengine.domain.AutoValue_NewInstance_NetworkInterface;
import org.jclouds.googlecomputeengine.domain.Instance;
import org.jclouds.googlecomputeengine.domain.Metadata;
import org.jclouds.googlecomputeengine.domain.Tags;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class NewInstance {
    public abstract String name();

    public abstract URI machineType();

    @Nullable
    public abstract Boolean canIpForward();

    public abstract List<NetworkInterface> networkInterfaces();

    public abstract List<AttachDisk> disks();

    @Nullable
    public abstract String description();

    public abstract Tags tags();

    public abstract Metadata metadata();

    @Nullable
    public abstract List<Instance.ServiceAccount> serviceAccounts();

    @Nullable
    public abstract Instance.Scheduling scheduling();

    public static NewInstance create(String name, URI machineType, URI network, URI sourceImage) {
        return NewInstance.create(name, machineType, network, Arrays.asList(AttachDisk.newBootDisk(sourceImage)), null);
    }

    public static NewInstance create(String name, URI machineType, URI network, List<AttachDisk> disks, String description) {
        Preconditions.checkArgument((boolean)disks.get(0).boot(), (String)"disk 0 must be a boot disk! %s", (Object[])new Object[]{disks});
        boolean foundBoot = false;
        for (AttachDisk disk : disks) {
            if (!disk.boot()) continue;
            Preconditions.checkArgument((!foundBoot ? 1 : 0) != 0, (String)"There must be only one boot disk! %s", (Object[])new Object[]{disks});
            foundBoot = true;
        }
        return NewInstance.create(name, machineType, null, (List<NetworkInterface>)ImmutableList.of((Object)NetworkInterface.create(network)), (List<AttachDisk>)ImmutableList.copyOf(disks), description, Tags.create(), Metadata.create(), null, null);
    }

    @SerializedNames(value={"name", "machineType", "canIpForward", "networkInterfaces", "disks", "description", "tags", "metadata", "serviceAccounts", "scheduling"})
    static NewInstance create(String name, URI machineType, Boolean canIpForward, List<NetworkInterface> networkInterfaces, List<AttachDisk> disks, String description, Tags tags, Metadata metadata, List<Instance.ServiceAccount> serviceAccounts, Instance.Scheduling scheduling) {
        return new AutoValue_NewInstance(name, machineType, canIpForward, networkInterfaces, disks, description, tags, metadata, serviceAccounts, scheduling);
    }

    NewInstance() {
    }

    static abstract class NetworkInterface {
        abstract URI network();

        abstract List<Instance.NetworkInterface.AccessConfig> accessConfigs();

        static NetworkInterface create(URI network) {
            return NetworkInterface.create(network, Arrays.asList(Instance.NetworkInterface.AccessConfig.create(null, Instance.NetworkInterface.AccessConfig.Type.ONE_TO_ONE_NAT, null)));
        }

        @SerializedNames(value={"network", "accessConfigs"})
        static NetworkInterface create(URI network, List<Instance.NetworkInterface.AccessConfig> accessConfigs) {
            return new AutoValue_NewInstance_NetworkInterface(network, accessConfigs);
        }

        NetworkInterface() {
        }
    }
}

