/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.domain;

import java.net.URI;
import java.util.Date;
import java.util.List;
import org.jclouds.googlecomputeengine.domain.AutoValue_BackendService;
import org.jclouds.googlecomputeengine.domain.AutoValue_BackendService_Backend;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class BackendService {
    public abstract String id();

    public abstract Date creationTimestamp();

    public abstract URI selfLink();

    public abstract String name();

    @Nullable
    public abstract String description();

    @Nullable
    public abstract List<Backend> backends();

    @Nullable
    public abstract List<URI> healthChecks();

    @Nullable
    public abstract int timeoutSec();

    @Nullable
    public abstract int port();

    @Nullable
    public abstract String protocol();

    @Nullable
    public abstract String fingerprint();

    @Nullable
    public abstract String portName();

    @SerializedNames(value={"id", "creationTimestamp", "selfLink", "name", "description", "backends", "healthChecks", "timeoutSec", "port", "protocol", "fingerprint", "portName"})
    public static BackendService create(String id, Date creationTimestamp, URI selfLink, String name, @Nullable String description, @Nullable List<Backend> backends, List<URI> healthChecks, @Nullable Integer timeoutSec, @Nullable Integer port, @Nullable String protocol, @Nullable String fingerprint, String portName) {
        return new AutoValue_BackendService(id, creationTimestamp, selfLink, name, description, backends, healthChecks, timeoutSec != null ? timeoutSec : 30, port != null ? port : 80, protocol, fingerprint, portName);
    }

    BackendService() {
    }

    public static abstract class Backend {
        @Nullable
        public abstract String description();

        public abstract URI group();

        @Nullable
        public abstract BalancingModes balancingMode();

        @Nullable
        public abstract Float maxUtilization();

        @Nullable
        public abstract Integer maxRate();

        @Nullable
        public abstract Float maxRatePerInstance();

        @Nullable
        public abstract Float capacityScaler();

        @SerializedNames(value={"description", "group", "balancingMode", "maxUtilization", "maxRate", "maxRatePerInstance", "capacityScaler"})
        public static Backend create(String description, URI group, BalancingModes balancingMode, Float maxUtilization, Integer maxRate, Float maxRatePerInstance, Float capacityScaler) {
            return new AutoValue_BackendService_Backend(description, group, balancingMode, maxUtilization, maxRate, maxRatePerInstance, capacityScaler);
        }

        public static Backend create(URI group) {
            return Backend.create(null, group, null, null, null, null, null);
        }

        Backend() {
        }

        public static enum BalancingModes {
            RATE,
            UTILIZATION;

        }
    }
}

