/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.domain;

import java.net.URI;
import java.util.List;
import org.jclouds.googlecomputeengine.domain.AutoValue_AttachDisk;
import org.jclouds.googlecomputeengine.domain.AutoValue_AttachDisk_InitializeParams;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class AttachDisk {
    public abstract Type type();

    @Nullable
    public abstract Mode mode();

    @Nullable
    public abstract URI source();

    @Nullable
    public abstract String deviceName();

    public abstract boolean boot();

    @Nullable
    public abstract InitializeParams initializeParams();

    public abstract boolean autoDelete();

    @Nullable
    public abstract List<String> licenses();

    @Nullable
    public abstract DiskInterface diskInterface();

    public static AttachDisk existingBootDisk(URI existingBootDisk) {
        return AttachDisk.create(Type.PERSISTENT, existingBootDisk, null, true, false);
    }

    public static AttachDisk newBootDisk(URI sourceImage) {
        return AttachDisk.create(Type.PERSISTENT, null, InitializeParams.create(sourceImage), true, true);
    }

    public static AttachDisk existingDisk(URI existingDisk) {
        return AttachDisk.create(Type.PERSISTENT, existingDisk, null, false, false);
    }

    static AttachDisk create(Type type, URI source, InitializeParams initializeParams, boolean boot, boolean autoDelete) {
        return AttachDisk.create(type, null, source, null, boot, initializeParams, autoDelete, null, null);
    }

    @SerializedNames(value={"type", "mode", "source", "deviceName", "boot", "initializeParams", "autoDelete", "licenses", "interface"})
    public static AttachDisk create(Type type, Mode mode, URI source, String deviceName, boolean boot, InitializeParams initializeParams, boolean autoDelete, List<String> licenses, DiskInterface diskInterface) {
        return new AutoValue_AttachDisk(type, mode, source, deviceName, boot, initializeParams, autoDelete, licenses, diskInterface);
    }

    AttachDisk() {
    }

    public static enum DiskInterface {
        NVME,
        SCSI;

    }

    public static enum Mode {
        READ_WRITE,
        READ_ONLY;

    }

    public static enum Type {
        PERSISTENT,
        SCRATCH;

    }

    public static abstract class InitializeParams {
        @Nullable
        public abstract String diskName();

        @Nullable
        public abstract Long diskSizeGb();

        public abstract URI sourceImage();

        @Nullable
        public abstract String diskType();

        static InitializeParams create(URI sourceImage) {
            return InitializeParams.create(null, null, sourceImage, null);
        }

        @SerializedNames(value={"diskName", "diskSizeGb", "sourceImage", "diskType"})
        public static InitializeParams create(String diskName, Long diskSizeGb, URI sourceImage, String diskType) {
            return new AutoValue_AttachDisk_InitializeParams(diskName, diskSizeGb, sourceImage, diskType);
        }

        InitializeParams() {
        }
    }
}

