/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.compute;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Atomics;
import com.google.common.util.concurrent.UncheckedTimeoutException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.googlecloud.internal.ListPages;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.compute.functions.FirewallTagNamingConvention;
import org.jclouds.googlecomputeengine.compute.functions.Resources;
import org.jclouds.googlecomputeengine.compute.options.GoogleComputeEngineTemplateOptions;
import org.jclouds.googlecomputeengine.domain.AttachDisk;
import org.jclouds.googlecomputeengine.domain.Image;
import org.jclouds.googlecomputeengine.domain.Instance;
import org.jclouds.googlecomputeengine.domain.MachineType;
import org.jclouds.googlecomputeengine.domain.NewInstance;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.domain.Region;
import org.jclouds.googlecomputeengine.features.InstanceApi;
import org.jclouds.location.suppliers.all.JustProvider;

public final class GoogleComputeEngineServiceAdapter
implements ComputeServiceAdapter<Instance, MachineType, Image, Location> {
    private final JustProvider justProvider;
    private final GoogleComputeEngineApi api;
    private final Resources resources;
    private final Map<URI, URI> diskToSourceImage;
    private final Predicate<AtomicReference<Operation>> operationDone;
    private final Predicate<AtomicReference<Instance>> instanceVisible;
    private final FirewallTagNamingConvention.Factory firewallTagNamingConvention;
    private final List<String> imageProjects;

    @Inject
    GoogleComputeEngineServiceAdapter(JustProvider justProvider, GoogleComputeEngineApi api, Predicate<AtomicReference<Operation>> operationDone, Predicate<AtomicReference<Instance>> instanceVisible, Map<URI, URI> diskToSourceImage, Resources resources, FirewallTagNamingConvention.Factory firewallTagNamingConvention, @Named(value="jclouds.google-compute-engine.image-projects") String imageProjects) {
        this.justProvider = justProvider;
        this.api = api;
        this.operationDone = operationDone;
        this.instanceVisible = instanceVisible;
        this.diskToSourceImage = diskToSourceImage;
        this.resources = resources;
        this.firewallTagNamingConvention = firewallTagNamingConvention;
        this.imageProjects = Splitter.on((char)',').omitEmptyStrings().splitToList((CharSequence)imageProjects);
    }

    public ComputeServiceAdapter.NodeAndInitialCredentials<Instance> createNodeWithGroupEncodedIntoName(String group, String name, Template template) {
        GoogleComputeEngineTemplateOptions options = (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(template.getOptions()));
        Preconditions.checkNotNull((Object)options.network(), (Object)"template options must specify a network");
        Preconditions.checkNotNull((Object)template.getHardware().getUri(), (Object)"hardware must have a URI");
        Preconditions.checkNotNull((Object)template.getImage().getUri(), (Object)"image URI is null");
        ArrayList disks = Lists.newArrayList();
        disks.add(AttachDisk.newBootDisk(template.getImage().getUri()));
        NewInstance newInstance = NewInstance.create(name, template.getHardware().getUri(), options.network(), disks, group);
        newInstance.tags().items().addAll(options.getTags());
        FirewallTagNamingConvention naming = this.firewallTagNamingConvention.get(group);
        for (int port : options.getInboundPorts()) {
            newInstance.tags().items().add(naming.name(port));
        }
        newInstance.metadata().putAll(options.getUserMetadata());
        LoginCredentials credentials = this.resolveNodeCredentials(template);
        if (options.getPublicKey() != null) {
            newInstance.metadata().put("sshKeys", String.format("%s:%s %s@localhost", credentials.getUser(), options.getPublicKey(), credentials.getUser()));
        }
        String zone = template.getLocation().getId();
        InstanceApi instanceApi = this.api.instancesInZone(zone);
        Operation create = instanceApi.create(newInstance);
        AtomicReference instance = Atomics.newReference((Object)Instance.create("0000000000000000000", null, create.targetLink(), newInstance.name(), newInstance.description(), newInstance.tags(), newInstance.machineType(), Instance.Status.PROVISIONING, null, create.zone(), null, null, null, newInstance.metadata(), null, Instance.Scheduling.create(Instance.Scheduling.OnHostMaintenance.MIGRATE, true)));
        Preconditions.checkState((boolean)this.instanceVisible.apply((Object)instance), (String)"instance %s is not api visible!", (Object[])new Object[]{instance.get()});
        this.diskToSourceImage.put(((Instance)instance.get()).disks().get(0).source(), template.getImage().getUri());
        return new ComputeServiceAdapter.NodeAndInitialCredentials(instance.get(), ((Instance)instance.get()).selfLink().toString(), credentials);
    }

    public Iterable<MachineType> listHardwareProfiles() {
        return Iterables.filter((Iterable)ListPages.concat(this.api.aggregatedList().machineTypes()), (Predicate)new Predicate<MachineType>(){

            public boolean apply(MachineType input) {
                return input.deprecated() == null;
            }
        });
    }

    public Iterable<Image> listImages() {
        ArrayList images = Lists.newArrayList();
        images.add(ListPages.concat(this.api.images().list()));
        for (String project : this.imageProjects) {
            images.add(ListPages.concat(this.api.images().listInProject(project)));
        }
        return Iterables.concat((Iterable)images);
    }

    public Image getImage(String selfLink) {
        return this.api.images().get(URI.create((String)Preconditions.checkNotNull((Object)selfLink, (Object)"id")));
    }

    public Iterable<Location> listLocations() {
        Location provider = (Location)this.justProvider.get().iterator().next();
        ImmutableList.Builder zones = ImmutableList.builder();
        for (Region region : ListPages.concat(this.api.regions().list())) {
            Location regionLocation = new LocationBuilder().scope(LocationScope.REGION).id(region.name()).description(region.selfLink().toString()).parent(provider).build();
            for (URI zoneSelfLink : region.zones()) {
                String zoneName = GoogleComputeEngineServiceAdapter.toName(zoneSelfLink);
                zones.add((Object)new LocationBuilder().scope(LocationScope.ZONE).id(zoneName).description(zoneSelfLink.toString()).parent(regionLocation).build());
            }
        }
        return zones.build();
    }

    public Instance getNode(String selfLink) {
        return this.resources.instance(URI.create((String)Preconditions.checkNotNull((Object)selfLink, (Object)"id")));
    }

    public Iterable<Instance> listNodes() {
        return ListPages.concat(this.api.aggregatedList().instances());
    }

    public Iterable<Instance> listNodesByIds(final Iterable<String> selfLinks) {
        return Iterables.filter(this.listNodes(), (Predicate)new Predicate<Instance>(){

            public boolean apply(Instance instance) {
                return Iterables.contains((Iterable)selfLinks, (Object)instance.selfLink().toString());
            }
        });
    }

    public void destroyNode(String selfLink) {
        this.waitOperationDone(this.resources.delete(URI.create((String)Preconditions.checkNotNull((Object)selfLink, (Object)"id"))));
    }

    public void rebootNode(String selfLink) {
        this.waitOperationDone(this.resources.resetInstance(URI.create((String)Preconditions.checkNotNull((Object)selfLink, (Object)"id"))));
    }

    public void resumeNode(String name) {
        throw new UnsupportedOperationException("resume is not supported by GCE");
    }

    public void suspendNode(String name) {
        throw new UnsupportedOperationException("suspend is not supported by GCE");
    }

    private void waitOperationDone(Operation operation) {
        AtomicReference operationRef = Atomics.newReference((Object)operation);
        if (!this.operationDone.apply((Object)operationRef)) {
            throw new UncheckedTimeoutException("operation did not reach DONE state" + operationRef.get());
        }
        if (((Operation)operationRef.get()).httpErrorStatusCode() != null) {
            throw new IllegalStateException("operation failed. Http Error Code: " + ((Operation)operationRef.get()).httpErrorStatusCode() + " HttpError: " + ((Operation)operationRef.get()).httpErrorMessage());
        }
    }

    private LoginCredentials resolveNodeCredentials(Template template) {
        TemplateOptions options = template.getOptions();
        LoginCredentials.Builder credentials = LoginCredentials.builder((Credentials)template.getImage().getDefaultCredentials());
        if (!Strings.isNullOrEmpty((String)options.getLoginUser())) {
            credentials.user(options.getLoginUser());
        }
        if (!Strings.isNullOrEmpty((String)options.getLoginPrivateKey())) {
            credentials.privateKey(options.getLoginPrivateKey());
        }
        if (!Strings.isNullOrEmpty((String)options.getLoginPassword())) {
            credentials.password(options.getLoginPassword());
        }
        if (options.shouldAuthenticateSudo() != null) {
            credentials.authenticateSudo(options.shouldAuthenticateSudo().booleanValue());
        }
        return credentials.build();
    }

    private static String toName(URI link) {
        String path = link.getPath();
        return path.substring(path.lastIndexOf(47) + 1);
    }
}

