/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.abiquo.http.filters;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.abiquo.functions.AppendApiVersionToAbiquoMimeType;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;

@Singleton
public class AppendApiVersionToMediaType
implements HttpRequestFilter {
    private AppendApiVersionToAbiquoMimeType versionAppender;

    @Inject
    AppendApiVersionToMediaType(AppendApiVersionToAbiquoMimeType versionAppender) {
        this.versionAppender = versionAppender;
    }

    public HttpRequest filter(HttpRequest request) throws HttpException {
        HttpRequest requestWithVersionInMediaTypes = this.appendVersionToNonPayloadHeaders(request);
        return this.appendVersionToPayloadHeaders(requestWithVersionInMediaTypes);
    }

    @VisibleForTesting
    HttpRequest appendVersionToNonPayloadHeaders(HttpRequest request) {
        Collection accept = request.getHeaders().get((Object)"Accept");
        return accept.isEmpty() ? request : ((HttpRequest.Builder)request.toBuilder().replaceHeader("Accept", (String[])Iterables.toArray((Iterable)Iterables.transform((Iterable)accept, (Function)this.versionAppender), String.class))).build();
    }

    @VisibleForTesting
    HttpRequest appendVersionToPayloadHeaders(HttpRequest request) {
        if (request.getPayload() != null) {
            String contentTypeWithVersion = this.versionAppender.apply(request.getPayload().getContentMetadata().getContentType());
            request.getPayload().getContentMetadata().setContentType(contentTypeWithVersion);
        }
        return request;
    }
}

