/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.abiquo.http.filters;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.abiquo.config.Authentication;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;

@Singleton
public class AbiquoAuthentication
implements HttpRequestFilter {
    private final Supplier<String> authTokenProvider;

    @Inject
    AbiquoAuthentication(@Authentication Supplier<String> authTokenProvider) {
        this.authTokenProvider = (Supplier)Preconditions.checkNotNull(authTokenProvider, (Object)"authTokenProvider must not be null");
    }

    public HttpRequest filter(HttpRequest request) throws HttpException {
        return ((HttpRequest.Builder)request.toBuilder().replaceHeader("Cookie", new String[]{AbiquoAuthentication.tokenAuth((String)this.authTokenProvider.get())})).build();
    }

    private static String tokenAuth(String token) {
        return "auth=" + (String)Preconditions.checkNotNull((Object)token, (Object)"missing authentication token");
    }
}

