/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.abiquo.handlers;

import java.io.Closeable;
import javax.inject.Singleton;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.util.Closeables2;

@Singleton
public class AbiquoErrorHandler
implements HttpErrorHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleError(HttpCommand command, HttpResponse response) {
        ResourceNotFoundException exception = null;
        String defaultMessage = String.format("%s -> %s", command.getCurrentRequest().getRequestLine(), response.getStatusLine());
        try {
            switch (response.getStatusCode()) {
                case 401: 
                case 403: {
                    exception = new AuthorizationException(defaultMessage, (Throwable)new HttpResponseException(command, response, defaultMessage));
                    return;
                }
                case 404: {
                    exception = new ResourceNotFoundException(defaultMessage);
                    return;
                }
                case 301: {
                    exception = new HttpResponseException(command, response, defaultMessage);
                    return;
                }
                default: {
                    exception = new HttpResponseException(response.getMessage(), command, response);
                    return;
                }
            }
        }
        finally {
            Closeables2.closeQuietly((Closeable)response.getPayload());
            command.setException((Exception)exception);
        }
    }
}

