/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.abiquo.functions.auth;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.net.HttpCookie;
import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.filters.BasicAuthentication;
import org.jclouds.logging.Logger;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.HttpClient;

@Singleton
public class GetTokenFromApi
implements Function<Credentials, String> {
    private final ProviderMetadata provider;
    private final HttpClient http;
    @Resource
    @Named(value="jclouds.abiquo")
    protected Logger logger = Logger.NULL;

    @Inject
    GetTokenFromApi(ProviderMetadata provider, HttpClient http) {
        this.provider = (ProviderMetadata)Preconditions.checkNotNull((Object)provider, (Object)"provider must not be null");
        this.http = (HttpClient)Preconditions.checkNotNull((Object)http, (Object)"http must not be null");
    }

    public String apply(Credentials input) {
        this.logger.info(">> Requesting an authentication token for user: %s...", new Object[]{input.identity});
        HttpResponse response = this.http.invoke(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create(this.provider.getEndpoint() + "/login")).addHeader("Authorization", new String[]{BasicAuthentication.basic((String)input.identity, (String)input.credential)})).build());
        Optional<HttpCookie> token = GetTokenFromApi.readAuthenticationToken(response);
        if (!token.isPresent()) {
            throw new AuthorizationException("Could not obtain a new authentication token");
        }
        return ((HttpCookie)token.get()).getValue();
    }

    @VisibleForTesting
    static Optional<HttpCookie> readAuthenticationToken(HttpResponse response) {
        Collection headers = response.getHeaders().get((Object)"Set-Cookie");
        Iterator i$ = headers.iterator();
        if (i$.hasNext()) {
            String header = (String)i$.next();
            List<HttpCookie> cookies = HttpCookie.parse(header);
            return Iterables.tryFind(cookies, (Predicate)new Predicate<HttpCookie>(){

                public boolean apply(HttpCookie input) {
                    return input.getName().equals("auth");
                }
            });
        }
        return Optional.absent();
    }
}

