/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.abiquo.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.rest.annotations.ApiVersion;

@Singleton
public class AppendApiVersionToAbiquoMimeType
implements Function<String, String> {
    private static final String ABIQUO_MIME_TYPE_PREFIX = "application/vnd.abiquo.";
    protected String apiVersion;

    @Inject
    AppendApiVersionToAbiquoMimeType(@ApiVersion String apiVersion) {
        this.apiVersion = (String)Preconditions.checkNotNull((Object)apiVersion, (Object)"apiVersion");
    }

    public String apply(String input) {
        Preconditions.checkNotNull((Object)input, (Object)"input");
        if (input.startsWith(ABIQUO_MIME_TYPE_PREFIX) && !input.contains("version")) {
            return input + ";version=" + this.apiVersion;
        }
        return input;
    }
}

