/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.abiquo.config;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.abiquo.config.Authentication;
import org.jclouds.abiquo.functions.auth.GetTokenFromApi;
import org.jclouds.abiquo.functions.auth.GetTokenFromCredentials;
import org.jclouds.domain.Credentials;
import org.jclouds.location.Provider;

public class AbiquoAuthenticationModule
extends AbstractModule {
    public static final String AUTH_TOKEN_NAME = "auth";

    @Provides
    @Singleton
    protected Map<String, Function<Credentials, String>> authenticationMethods(GetTokenFromApi tokenFromApi, GetTokenFromCredentials tokenFromCredentials) {
        return ImmutableMap.of((Object)"password", (Object)tokenFromApi, (Object)"token", (Object)tokenFromCredentials);
    }

    @Provides
    @Singleton
    protected Function<Credentials, String> authenticationMethodForCredentialType(Map<String, Function<Credentials, String>> authenticationMethods, @Named(value="abiquo.credential-type") String credentialType) {
        Preconditions.checkArgument((boolean)authenticationMethods.containsKey(credentialType), (String)"credential type %s not in supported list: %s", (Object[])new Object[]{credentialType, authenticationMethods.keySet()});
        return authenticationMethods.get(credentialType);
    }

    @Provides
    @Singleton
    protected LoadingCache<Credentials, String> provideTokenCache(Function<Credentials, String> getToken) {
        return CacheBuilder.newBuilder().expireAfterWrite(29L, TimeUnit.MINUTES).build(CacheLoader.from(getToken));
    }

    @Provides
    @Singleton
    @Authentication
    protected Supplier<String> provideTokenSupplier(final LoadingCache<Credentials, String> cache, final @Provider Supplier<Credentials> creds) {
        return new Supplier<String>(){

            public String get() {
                return (String)cache.getUnchecked(creds.get());
            }
        };
    }

    protected void configure() {
    }
}

