/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.abiquo;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import org.jclouds.abiquo.AbiquoApi;
import org.jclouds.abiquo.config.AbiquoAuthenticationModule;
import org.jclouds.abiquo.config.AbiquoHttpApiModule;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.rest.internal.BaseHttpApiMetadata;

@AutoService(value=ApiMetadata.class)
public class AbiquoApiMetadata
extends BaseHttpApiMetadata<AbiquoApi> {
    public AbiquoApiMetadata() {
        this(new Builder());
    }

    public Builder toBuilder() {
        return (Builder)new Builder().fromApiMetadata((ApiMetadata)this);
    }

    protected AbiquoApiMetadata(Builder builder) {
        super((BaseHttpApiMetadata.Builder)builder);
    }

    public static Properties defaultProperties() {
        Properties properties = BaseHttpApiMetadata.defaultProperties();
        properties.setProperty("abiquo.credential-type", "password");
        return properties;
    }

    public static class Builder
    extends BaseHttpApiMetadata.Builder<AbiquoApi, Builder> {
        protected Builder() {
            ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id("abiquo")).name("Abiquo API")).identityName("API Username")).credentialName("API Password")).documentation(URI.create("http://wiki.abiquo.com/display/ABI32/Api+Reference"))).defaultEndpoint("http://localhost/api")).version("3.2")).defaultProperties(AbiquoApiMetadata.defaultProperties())).defaultModules((Set)ImmutableSet.of(AbiquoHttpApiModule.class, AbiquoAuthenticationModule.class));
        }

        public AbiquoApiMetadata build() {
            return new AbiquoApiMetadata(this);
        }

        protected Builder self() {
            return this;
        }
    }
}

