/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos;

import com.google.inject.Provides;
import java.io.Closeable;
import java.net.URI;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.atmos.binders.BindMetadataToHeaders;
import org.jclouds.atmos.domain.AtmosObject;
import org.jclouds.atmos.domain.BoundedSet;
import org.jclouds.atmos.domain.DirectoryEntry;
import org.jclouds.atmos.domain.SystemMetadata;
import org.jclouds.atmos.domain.UserMetadata;
import org.jclouds.atmos.fallbacks.TrueOn404FalseOnPathNotEmpty;
import org.jclouds.atmos.filters.SignRequest;
import org.jclouds.atmos.functions.AtmosObjectName;
import org.jclouds.atmos.functions.ParseDirectoryListFromContentAndHeaders;
import org.jclouds.atmos.functions.ParseNullableURIFromListOrLocationHeaderIf20x;
import org.jclouds.atmos.functions.ParseObjectFromHeadersAndHttpContent;
import org.jclouds.atmos.functions.ParseSystemMetadataFromHeaders;
import org.jclouds.atmos.functions.ParseUserMetadataFromHeaders;
import org.jclouds.atmos.functions.ReturnTrueIfGroupACLIsOtherRead;
import org.jclouds.atmos.options.ListOptions;
import org.jclouds.atmos.options.PutOptions;
import org.jclouds.blobstore.BlobStoreFallbacks;
import org.jclouds.http.options.GetOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.ParamParser;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;

@RequestFilters(value={SignRequest.class})
@Path(value="/rest/namespace")
public interface AtmosClient
extends Closeable {
    @Provides
    public AtmosObject newObject();

    @Named(value="ListDirectory")
    @GET
    @Path(value="/")
    @ResponseParser(value=ParseDirectoryListFromContentAndHeaders.class)
    @Consumes(value={"text/xml"})
    public BoundedSet<? extends DirectoryEntry> listDirectories(ListOptions ... var1);

    @Named(value="ListDirectory")
    @GET
    @Path(value="/{directoryName}/")
    @ResponseParser(value=ParseDirectoryListFromContentAndHeaders.class)
    @Fallback(value=BlobStoreFallbacks.ThrowContainerNotFoundOn404.class)
    @Consumes(value={"text/xml"})
    @Headers(keys={"x-emc-include-meta"}, values={"1"})
    public BoundedSet<? extends DirectoryEntry> listDirectory(@PathParam(value="directoryName") String var1, ListOptions ... var2);

    @Named(value="CreateDirectory")
    @POST
    @Path(value="/{directoryName}/")
    @Fallback(value=BlobStoreFallbacks.NullOnKeyAlreadyExists.class)
    @Produces(value={"application/octet-stream"})
    @Consumes(value={"*/*"})
    public URI createDirectory(@PathParam(value="directoryName") String var1, PutOptions ... var2);

    @Nullable
    @Named(value="CreateObject")
    @POST
    @Path(value="/{parent}/{name}")
    @Headers(keys={"Expect"}, values={"100-continue"})
    @ResponseParser(value=ParseNullableURIFromListOrLocationHeaderIf20x.class)
    @Consumes(value={"*/*"})
    public URI createFile(@PathParam(value="parent") String var1, @PathParam(value="name") @ParamParser(value=AtmosObjectName.class) @BinderParam(value=BindMetadataToHeaders.class) AtmosObject var2, PutOptions ... var3);

    @Named(value="UpdateObject")
    @PUT
    @Path(value="/{parent}/{name}")
    @Headers(keys={"Expect"}, values={"100-continue"})
    @Fallback(value=BlobStoreFallbacks.ThrowKeyNotFoundOn404.class)
    @Consumes(value={"*/*"})
    public void updateFile(@PathParam(value="parent") String var1, @PathParam(value="name") @ParamParser(value=AtmosObjectName.class) @BinderParam(value=BindMetadataToHeaders.class) AtmosObject var2, PutOptions ... var3);

    @Named(value="ReadObject")
    @GET
    @ResponseParser(value=ParseObjectFromHeadersAndHttpContent.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Path(value="/{path}")
    @Consumes(value={"*/*"})
    public AtmosObject readFile(@PathParam(value="path") String var1, GetOptions ... var2);

    @Named(value="GetObjectMetadata")
    @HEAD
    @ResponseParser(value=ParseObjectFromHeadersAndHttpContent.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Path(value="/{path}")
    @Consumes(value={"*/*"})
    public AtmosObject headFile(@PathParam(value="path") String var1);

    @Named(value="GetSystemMetadata")
    @HEAD
    @ResponseParser(value=ParseSystemMetadataFromHeaders.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Path(value="/{path}")
    @Consumes(value={"*/*"})
    public SystemMetadata getSystemMetadata(@PathParam(value="path") String var1);

    @Named(value="GetUserMetadata")
    @HEAD
    @ResponseParser(value=ParseUserMetadataFromHeaders.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Path(value="/{path}")
    @QueryParams(keys={"metadata/user"})
    @Consumes(value={"*/*"})
    public UserMetadata getUserMetadata(@PathParam(value="path") String var1);

    @Named(value="DeleteObject")
    @DELETE
    @Fallback(value=TrueOn404FalseOnPathNotEmpty.class)
    @Path(value="/{path}")
    @Consumes(value={"*/*"})
    public boolean deletePath(@PathParam(value="path") String var1);

    @Named(value="GetObjectMetadata")
    @HEAD
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    @Path(value="/{path}")
    @Consumes(value={"*/*"})
    public boolean pathExists(@PathParam(value="path") String var1);

    @Named(value="GetObjectMetadata")
    @HEAD
    @ResponseParser(value=ReturnTrueIfGroupACLIsOtherRead.class)
    @Path(value="/{path}")
    @Consumes(value={"*/*"})
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean isPublic(@PathParam(value="path") String var1);

    @Named(value="SetObjectMetadata")
    @POST
    @Path(value="/{path}")
    @QueryParams(keys={"acl"})
    @Produces(value={"application/octet-stream"})
    @Fallback(value=BlobStoreFallbacks.ThrowKeyNotFoundOn404.class)
    @Consumes(value={"*/*"})
    public void setGroupAcl(@PathParam(value="path") String var1, PutOptions var2);
}

