/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.gson.reflect.TypeToken;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.inject.Inject;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.internal.PageSetImpl;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.Uris;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.json.Json;
import org.jclouds.openstack.swift.domain.ObjectInfo;
import org.jclouds.openstack.swift.domain.internal.ObjectInfoImpl;
import org.jclouds.openstack.swift.options.ListContainerOptions;
import org.jclouds.rest.InvocationContext;
import org.jclouds.rest.internal.GeneratedHttpRequest;

public class ParseObjectInfoListFromJsonResponse
extends ParseJson<PageSet<ObjectInfo>>
implements InvocationContext<ParseObjectInfoListFromJsonResponse> {
    private List<Object> args;
    private String container;
    private GeneratedHttpRequest request;
    private ListContainerOptions options;

    @Inject
    public ParseObjectInfoListFromJsonResponse(Json json) {
        super(json, (TypeLiteral)new TypeLiteral<PageSet<ObjectInfo>>(){});
    }

    public PageSet<ObjectInfo> apply(InputStream stream) {
        Preconditions.checkState((this.args != null ? 1 : 0) != 0, (Object)"request should be initialized at this point");
        Type listType = new TypeToken<SortedSet<ObjectInfoImpl>>(){}.getType();
        try {
            SortedSet list = (SortedSet)this.apply(stream, listType);
            TreeSet returnVal = Sets.newTreeSet((Iterable)Iterables.transform((Iterable)list, (Function)new Function<ObjectInfoImpl, ObjectInfo>(){

                public ObjectInfo apply(ObjectInfoImpl from) {
                    return ((ObjectInfoImpl.Builder)((ObjectInfoImpl.Builder)from.toBuilder().container(ParseObjectInfoListFromJsonResponse.this.container)).uri(Uris.uriBuilder((URI)ParseObjectInfoListFromJsonResponse.this.request.getEndpoint()).clearQuery().appendPath(from.getName()).build())).build();
                }
            }));
            boolean truncated = this.options.getMaxResults() == returnVal.size();
            String marker = null;
            if (truncated && !returnVal.isEmpty()) {
                marker = ((ObjectInfo)returnVal.last()).getName();
            }
            return new PageSetImpl((Iterable)returnVal, marker);
        }
        catch (IOException e) {
            throw new RuntimeException("problem reading response from request: " + this.request, e);
        }
    }

    public ParseObjectInfoListFromJsonResponse setContext(HttpRequest request) {
        Preconditions.checkArgument((boolean)(request instanceof GeneratedHttpRequest), (Object)"note this handler requires a GeneratedHttpRequest");
        this.request = (GeneratedHttpRequest)GeneratedHttpRequest.class.cast(request);
        this.args = this.request.getInvocation().getArgs();
        Preconditions.checkArgument((boolean)(this.args.get(0) instanceof String), (Object)"arg[0] must be a container name");
        this.container = this.args.get(0).toString();
        Preconditions.checkArgument((boolean)(this.args.get(1) instanceof ListContainerOptions[]), (Object)"arg[1] must be an array of ListContainerOptions");
        ListContainerOptions[] optionsList = (ListContainerOptions[])this.args.get(1);
        this.options = optionsList.length > 0 ? optionsList[0] : ListContainerOptions.NONE;
        return this;
    }
}

