/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.config;

import com.google.common.base.Supplier;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import java.net.URI;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.json.config.GsonModule;
import org.jclouds.location.suppliers.RegionIdToURISupplier;
import org.jclouds.openstack.config.OpenStackAuthenticationModule;
import org.jclouds.openstack.functions.URIFromAuthenticationResponseForService;
import org.jclouds.openstack.keystone.v2_0.config.KeystoneAuthenticationModule;
import org.jclouds.openstack.swift.CommonSwiftClient;
import org.jclouds.openstack.swift.Storage;
import org.jclouds.openstack.swift.SwiftClient;
import org.jclouds.openstack.swift.config.SwiftObjectModule;
import org.jclouds.openstack.swift.handlers.ParseSwiftErrorFromHttpResponse;
import org.jclouds.rest.ConfiguresHttpApi;
import org.jclouds.rest.annotations.ApiVersion;
import org.jclouds.rest.config.HttpApiModule;
import org.jclouds.util.Suppliers2;

@ConfiguresHttpApi
public class SwiftHttpApiModule<S extends CommonSwiftClient>
extends HttpApiModule<S> {
    public SwiftHttpApiModule() {
        this((Class)Class.class.cast(SwiftClient.class));
    }

    protected SwiftHttpApiModule(Class<S> syncClientType) {
        super(syncClientType);
    }

    protected void configure() {
        this.install((Module)new SwiftObjectModule());
        this.bind(GsonModule.DateAdapter.class).to(GsonModule.Iso8601DateAdapter.class);
        super.configure();
        this.bindResolvedClientsToCommonSwift();
    }

    protected void bindResolvedClientsToCommonSwift() {
        this.bind(CommonSwiftClient.class).to(SwiftClient.class).in(Scopes.SINGLETON);
    }

    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(ParseSwiftErrorFromHttpResponse.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(ParseSwiftErrorFromHttpResponse.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(ParseSwiftErrorFromHttpResponse.class);
    }

    public static class KeystoneStorageEndpointModule
    extends KeystoneAuthenticationModule {
        @Provides
        @Singleton
        @Storage
        protected Supplier<URI> provideStorageUrl(RegionIdToURISupplier.Factory factory, @ApiVersion String apiVersion, @Named(value="jclouds.region") String region) {
            RegionIdToURISupplier endpointsSupplier = factory.createForApiTypeAndVersion("object-store", apiVersion);
            if (region.isEmpty()) {
                return Suppliers2.getLastValueInMap((Supplier)endpointsSupplier);
            }
            return Suppliers2.getValueInMapOrNull((Supplier)endpointsSupplier, (Object)region);
        }
    }

    public static class StorageEndpointModule
    extends OpenStackAuthenticationModule {
        @Provides
        @Singleton
        @Storage
        protected Supplier<URI> provideStorageUrl(URIFromAuthenticationResponseForService.Factory factory) {
            return factory.create("X-Storage-Url");
        }
    }
}

