/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.suppliers;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Resource;
import org.jclouds.logging.Logger;

public class SupplyKeyMatchingValueOrNull<K, V>
implements Supplier<K> {
    @Resource
    protected Logger logger = Logger.NULL;
    private final Supplier<Map<K, Supplier<V>>> supplier;
    private final Supplier<V> valueSupplier;

    public SupplyKeyMatchingValueOrNull(Supplier<Map<K, Supplier<V>>> supplier, Supplier<V> valueSupplier) {
        this.valueSupplier = valueSupplier;
        this.supplier = supplier;
    }

    public K get() {
        Object uri = this.valueSupplier.get();
        Map map = Maps.transformValues((Map)((Map)this.supplier.get()), (Function)Suppliers.supplierFunction());
        Object region = ImmutableBiMap.copyOf((Map)map).inverse().get(uri);
        if (region == null && !map.isEmpty()) {
            region = Iterables.get(map.keySet(), (int)0);
            this.logger.warn("failed to find key for value %s in %s; choosing first: %s", uri, map, region);
        }
        return (K)region;
    }
}

