/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.monitoring.monit;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.SoftwareProcessImpl;
import brooklyn.entity.monitoring.monit.MonitDriver;
import brooklyn.entity.monitoring.monit.MonitNode;
import brooklyn.event.feed.ssh.SshFeed;
import brooklyn.event.feed.ssh.SshPollConfig;
import brooklyn.event.feed.ssh.SshPollValue;
import brooklyn.location.Location;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.util.text.Strings;
import brooklyn.util.time.Duration;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitNodeImpl
extends SoftwareProcessImpl
implements MonitNode {
    private static final Logger LOG = LoggerFactory.getLogger(MonitNodeImpl.class);
    private SshFeed feed;

    public MonitNodeImpl() {
    }

    public MonitNodeImpl(Map flags) {
        super(flags, null);
    }

    public MonitNodeImpl(Map flags, Entity parent) {
        super(flags, parent);
    }

    public Class getDriverInterface() {
        return MonitDriver.class;
    }

    public MonitDriver getDriver() {
        return (MonitDriver)super.getDriver();
    }

    protected void connectSensors() {
        super.connectSensors();
        Location machine = (Location)Iterables.get((Iterable)this.getLocations(), (int)0, null);
        if (machine instanceof SshMachineLocation) {
            String cmd = this.getDriver().getStatusCmd();
            this.feed = SshFeed.builder().entity((EntityLocal)this).period(Duration.FIVE_SECONDS).machine((SshMachineLocation)machine).poll((SshPollConfig)((SshPollConfig)new SshPollConfig(SERVICE_UP).command(cmd).setOnSuccess((Object)true)).setOnFailureOrException((Object)false)).poll((SshPollConfig)((SshPollConfig)new SshPollConfig(MONIT_TARGET_PROCESS_NAME).command(cmd).onSuccess((Function)new Function<SshPollValue, String>(){

                public String apply(SshPollValue input) {
                    String process = Strings.getFirstWordAfter((String)input.getStdout(), (String)"Process");
                    return process;
                }
            })).setOnFailureOrException(null)).poll((SshPollConfig)((SshPollConfig)new SshPollConfig(MONIT_TARGET_PROCESS_STATUS).command(cmd).onSuccess((Function)new Function<SshPollValue, String>(){

                public String apply(SshPollValue input) {
                    return Strings.trim((String)Strings.getRemainderOfLineAfter((String)input.getStdout(), (String)"status"));
                }
            })).setOnFailureOrException(null)).build();
        } else {
            LOG.warn("Location(s) {} not an ssh-machine location, so not polling for status; setting serviceUp immediately", (Object)this.getLocations());
            this.setAttribute(SERVICE_UP, true);
        }
    }

    protected void disconnectSensors() {
        if (this.feed != null) {
            this.feed.stop();
        }
    }

    public String getShortName() {
        return "Monit";
    }
}

