/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.config;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.functions.PollNodeRunning;
import org.jclouds.compute.predicates.AtomicImageAvailable;
import org.jclouds.compute.predicates.AtomicImageDeleted;
import org.jclouds.compute.predicates.AtomicNodeRunning;
import org.jclouds.compute.predicates.AtomicNodeSuspended;
import org.jclouds.compute.predicates.AtomicNodeTerminated;
import org.jclouds.compute.predicates.ScriptStatusReturnsZero;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.util.Predicates2;

public class ComputeServiceTimeoutsModule
extends AbstractModule {
    @Provides
    @Singleton
    @Named(value="jclouds.compute.timeout.node-running")
    protected Predicate<AtomicReference<NodeMetadata>> nodeRunning(AtomicNodeRunning statusRunning, ComputeServiceConstants.Timeouts timeouts, ComputeServiceConstants.PollPeriod period) {
        return timeouts.nodeRunning == 0L ? statusRunning : RetryablePredicateGuardingNull.create(statusRunning, timeouts.nodeRunning, period.pollInitialPeriod, period.pollMaxPeriod);
    }

    @Provides
    @Singleton
    @Named(value="jclouds.compute.timeout.node-terminated")
    protected Predicate<AtomicReference<NodeMetadata>> serverTerminated(AtomicNodeTerminated statusTerminated, ComputeServiceConstants.Timeouts timeouts, ComputeServiceConstants.PollPeriod period) {
        return timeouts.nodeTerminated == 0L ? statusTerminated : Predicates2.retry((Predicate)statusTerminated, (long)timeouts.nodeTerminated, (long)period.pollInitialPeriod, (long)period.pollMaxPeriod);
    }

    @Provides
    @Singleton
    @Named(value="jclouds.compute.timeout.node-suspended")
    protected Predicate<AtomicReference<NodeMetadata>> serverSuspended(AtomicNodeSuspended statusSuspended, ComputeServiceConstants.Timeouts timeouts, ComputeServiceConstants.PollPeriod period) {
        return timeouts.nodeSuspended == 0L ? statusSuspended : RetryablePredicateGuardingNull.create(statusSuspended, timeouts.nodeSuspended, period.pollInitialPeriod, period.pollMaxPeriod);
    }

    @Provides
    @Singleton
    @Named(value="jclouds.compute.timeout.script-complete")
    protected Predicate<ScriptStatusReturnsZero.CommandUsingClient> runScriptRunning(ScriptStatusReturnsZero statusRunning, ComputeServiceConstants.Timeouts timeouts) {
        return timeouts.scriptComplete == 0L ? Predicates.not((Predicate)statusRunning) : Predicates2.retry((Predicate)Predicates.not((Predicate)statusRunning), (long)timeouts.scriptComplete);
    }

    @Provides
    @Singleton
    @Named(value="jclouds.compute.timeout.image-available")
    protected Predicate<AtomicReference<Image>> imageAvailable(AtomicImageAvailable statusAvailable, ComputeServiceConstants.Timeouts timeouts, ComputeServiceConstants.PollPeriod period) {
        return timeouts.imageAvailable == 0L ? statusAvailable : Predicates2.retry((Predicate)statusAvailable, (long)timeouts.imageAvailable, (long)period.pollInitialPeriod, (long)period.pollMaxPeriod);
    }

    @Provides
    @Singleton
    @Named(value="jclouds.compute.timeout.image-deleted")
    protected Predicate<AtomicReference<Image>> serverDeleted(AtomicImageDeleted statusDeleted, ComputeServiceConstants.Timeouts timeouts, ComputeServiceConstants.PollPeriod period) {
        return timeouts.imageDeleted == 0L ? statusDeleted : Predicates2.retry((Predicate)statusDeleted, (long)timeouts.imageDeleted, (long)period.pollInitialPeriod, (long)period.pollMaxPeriod);
    }

    protected void configure() {
        this.bind((TypeLiteral)new TypeLiteral<Function<AtomicReference<NodeMetadata>, AtomicReference<NodeMetadata>>>(){}).annotatedWith((Annotation)Names.named((String)"jclouds.compute.timeout.node-running")).to(PollNodeRunning.class);
    }

    private static class RetryablePredicateGuardingNull<T>
    implements Predicate<AtomicReference<T>> {
        private final Predicate<AtomicRefAndOrig> retryablePredicate;

        private static <T> RetryablePredicateGuardingNull<T> create(Predicate<AtomicReference<T>> predicate, long maxWait, long period, long maxPeriod) {
            return new RetryablePredicateGuardingNull<T>(predicate, maxWait, period, maxPeriod);
        }

        private RetryablePredicateGuardingNull(final Predicate<AtomicReference<T>> predicate, long maxWait, long period, long maxPeriod) {
            Predicate<AtomicRefAndOrig> nonNullThingPredicate = new Predicate<AtomicRefAndOrig>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean apply(AtomicRefAndOrig input) {
                    AtomicReference<Object> ref = input.ref.get() != null ? input.ref : new AtomicReference<Object>(input.orig);
                    try {
                        boolean bl = predicate.apply((Object)ref);
                        return bl;
                    }
                    finally {
                        input.ref.set(ref.get());
                    }
                }
            };
            this.retryablePredicate = Predicates2.retry((Predicate)nonNullThingPredicate, (long)maxWait, (long)period, (long)maxPeriod);
        }

        public boolean apply(AtomicReference<T> input) {
            AtomicRefAndOrig refAndOrig = new AtomicRefAndOrig(input.get(), input);
            return this.retryablePredicate.apply((Object)refAndOrig);
        }

        private class AtomicRefAndOrig {
            private final T orig;
            private final AtomicReference<T> ref;

            AtomicRefAndOrig(T orig, AtomicReference<T> ref) {
                this.orig = orig;
                this.ref = ref;
            }
        }
    }
}

