/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.azureblob.blobstore.functions.AzureBlobToBlob;
import org.jclouds.azureblob.domain.AzureBlob;
import org.jclouds.blobstore.binders.BindUserMetadataToHeadersWithPrefix;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

@Singleton
public class BindAzureBlobMetadataToRequest
implements Binder {
    private final AzureBlobToBlob azureBlob2Blob;
    private final BindUserMetadataToHeadersWithPrefix blobBinder;

    @Inject
    public BindAzureBlobMetadataToRequest(AzureBlobToBlob azureBlob2Blob, BindUserMetadataToHeadersWithPrefix blobBinder) {
        this.azureBlob2Blob = (AzureBlobToBlob)Preconditions.checkNotNull((Object)azureBlob2Blob, (Object)"azureBlob2Blob");
        this.blobBinder = (BindUserMetadataToHeadersWithPrefix)Preconditions.checkNotNull((Object)blobBinder, (Object)"blobBinder");
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)input, (Object)"input") instanceof AzureBlob), (Object)"this binder is only valid for AzureBlobs!");
        Preconditions.checkNotNull(request, (Object)"request");
        AzureBlob blob = (AzureBlob)AzureBlob.class.cast(input);
        Preconditions.checkArgument((blob.getPayload().getContentMetadata().getContentLength() != null && blob.getPayload().getContentMetadata().getContentLength() >= 0L ? 1 : 0) != 0, (Object)"size must be set");
        ImmutableMap.Builder headers = ImmutableMap.builder();
        headers.put((Object)"x-ms-blob-type", (Object)blob.getProperties().getType().toString());
        switch (blob.getProperties().getType()) {
            case PAGE_BLOB: {
                headers.put((Object)"Content-Length", (Object)"0");
                headers.put((Object)"x-ms-blob-content-length", (Object)blob.getPayload().getContentMetadata().getContentLength().toString());
                break;
            }
            case BLOCK_BLOB: {
                Preconditions.checkArgument(((Long)Preconditions.checkNotNull((Object)blob.getPayload().getContentMetadata().getContentLength(), (Object)"blob.getContentLength()") <= 0x4000000L ? 1 : 0) != 0, (Object)"maximum size for put Blob is 64MB");
            }
        }
        request = ((HttpRequest.Builder)request.toBuilder().replaceHeaders((Multimap)Multimaps.forMap((Map)headers.build()))).build();
        return (R)this.blobBinder.bindToRequest(request, (Object)this.azureBlob2Blob.apply(blob));
    }
}

