/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.launcher;

import brooklyn.catalog.internal.CatalogInitialization;
import brooklyn.config.BrooklynProperties;
import brooklyn.config.BrooklynServerConfig;
import brooklyn.config.BrooklynServerPaths;
import brooklyn.config.ConfigKey;
import brooklyn.config.ConfigMap;
import brooklyn.config.ConfigPredicates;
import brooklyn.config.StringConfigMap;
import brooklyn.entity.Application;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.ApplicationBuilder;
import brooklyn.entity.basic.BrooklynShutdownHooks;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.basic.StartableApplication;
import brooklyn.entity.brooklynnode.BrooklynNode;
import brooklyn.entity.brooklynnode.LocalBrooklynNode;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.entity.rebind.PersistenceExceptionHandler;
import brooklyn.entity.rebind.PersistenceExceptionHandlerImpl;
import brooklyn.entity.rebind.RebindManager;
import brooklyn.entity.rebind.RebindManagerImpl;
import brooklyn.entity.rebind.persister.BrooklynMementoPersisterToObjectStore;
import brooklyn.entity.rebind.persister.BrooklynPersistenceUtils;
import brooklyn.entity.rebind.persister.PersistMode;
import brooklyn.entity.rebind.persister.PersistenceObjectStore;
import brooklyn.entity.rebind.transformer.CompoundTransformer;
import brooklyn.entity.trait.Startable;
import brooklyn.launcher.BrooklynServerDetails;
import brooklyn.launcher.BrooklynWebServer;
import brooklyn.launcher.config.StopWhichAppsOnShutdown;
import brooklyn.location.Location;
import brooklyn.location.LocationSpec;
import brooklyn.location.PortRange;
import brooklyn.location.basic.LocalhostMachineProvisioningLocation;
import brooklyn.location.basic.PortRanges;
import brooklyn.management.ManagementContext;
import brooklyn.management.ha.HighAvailabilityManager;
import brooklyn.management.ha.HighAvailabilityManagerImpl;
import brooklyn.management.ha.HighAvailabilityMode;
import brooklyn.management.ha.ManagementNodeState;
import brooklyn.management.ha.ManagementPlaneSyncRecord;
import brooklyn.management.ha.ManagementPlaneSyncRecordPersister;
import brooklyn.management.ha.ManagementPlaneSyncRecordPersisterToObjectStore;
import brooklyn.management.internal.LocalManagementContext;
import brooklyn.management.internal.ManagementContextInternal;
import brooklyn.mementos.BrooklynMementoPersister;
import brooklyn.mementos.BrooklynMementoRawData;
import brooklyn.rest.BrooklynWebConfig;
import brooklyn.rest.filter.BrooklynPropertiesSecurityFilter;
import brooklyn.rest.security.provider.BrooklynUserWithRandomPasswordSecurityProvider;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.exceptions.FatalConfigurationRuntimeException;
import brooklyn.util.exceptions.FatalRuntimeException;
import brooklyn.util.exceptions.RuntimeInterruptedException;
import brooklyn.util.guava.Maybe;
import brooklyn.util.io.FileUtil;
import brooklyn.util.net.Networking;
import brooklyn.util.os.Os;
import brooklyn.util.stream.Streams;
import brooklyn.util.text.Strings;
import brooklyn.util.time.Duration;
import brooklyn.util.time.Time;
import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.brooklyn.camp.CampPlatform;
import io.brooklyn.camp.brooklyn.BrooklynCampPlatformLauncherNoServer;
import io.brooklyn.camp.brooklyn.spi.creation.BrooklynAssemblyTemplateInstantiator;
import io.brooklyn.camp.spi.AssemblyTemplate;
import io.brooklyn.camp.spi.instantiate.AssemblyTemplateInstantiator;
import java.io.Closeable;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynLauncher {
    private static final Logger LOG = LoggerFactory.getLogger(BrooklynLauncher.class);
    private final Map<String, Object> brooklynAdditionalProperties = Maps.newLinkedHashMap();
    private BrooklynProperties brooklynProperties;
    private ManagementContext managementContext;
    private final List<String> locationSpecs = new ArrayList<String>();
    private final List<Location> locations = new ArrayList<Location>();
    private final List<Application> appsToManage = new ArrayList<Application>();
    private final List<ApplicationBuilder> appBuildersToManage = new ArrayList<ApplicationBuilder>();
    private final List<String> yamlAppsToManage = new ArrayList<String>();
    private final List<Application> apps = new ArrayList<Application>();
    private boolean startWebApps = true;
    private boolean startBrooklynNode = false;
    private PortRange port = null;
    private Boolean useHttps = null;
    private InetAddress bindAddress = null;
    private InetAddress publicAddress = null;
    private Map<String, String> webApps = new LinkedHashMap<String, String>();
    private Map<String, ?> webconsoleFlags = Maps.newLinkedHashMap();
    private Boolean skipSecurityFilter = null;
    private boolean ignoreWebErrors = false;
    private boolean ignorePersistenceErrors = true;
    private boolean ignoreCatalogErrors = true;
    private boolean ignoreAppErrors = true;
    private StopWhichAppsOnShutdown stopWhichAppsOnShutdown = StopWhichAppsOnShutdown.THESE_IF_NOT_PERSISTED;
    private Function<ManagementContext, Void> customizeManagement = null;
    private CatalogInitialization catalogInitialization = null;
    private PersistMode persistMode = PersistMode.DISABLED;
    private HighAvailabilityMode highAvailabilityMode = HighAvailabilityMode.DISABLED;
    private String persistenceDir;
    private String persistenceLocation;
    private Duration persistPeriod = Duration.ONE_SECOND;
    private Duration haHeartbeatTimeoutOverride = null;
    private Duration haHeartbeatPeriodOverride = null;
    private volatile BrooklynWebServer webServer;
    private CampPlatform campPlatform;
    private boolean started;
    private String globalBrooklynPropertiesFile = Os.mergePaths((String[])new String[]{Os.home(), ".brooklyn", "brooklyn.properties"});
    private String localBrooklynPropertiesFile;

    public static BrooklynLauncher newInstance() {
        return new BrooklynLauncher();
    }

    public List<Application> getApplications() {
        if (!this.started) {
            throw new IllegalStateException("Cannot retrieve application until started");
        }
        return ImmutableList.copyOf(this.apps);
    }

    public BrooklynServerDetails getServerDetails() {
        if (!this.started) {
            throw new IllegalStateException("Cannot retrieve server details until started");
        }
        return new BrooklynServerDetails(this.webServer, this.managementContext);
    }

    public BrooklynLauncher application(Application app) {
        if (Entities.isManaged((Entity)app)) {
            throw new IllegalArgumentException("Application must not already be managed");
        }
        this.appsToManage.add((Application)Preconditions.checkNotNull((Object)app, (Object)"app"));
        return this;
    }

    public BrooklynLauncher application(ApplicationBuilder appBuilder) {
        this.appBuildersToManage.add((ApplicationBuilder)Preconditions.checkNotNull((Object)appBuilder, (Object)"appBuilder"));
        return this;
    }

    public BrooklynLauncher application(EntitySpec<? extends StartableApplication> appSpec) {
        this.appBuildersToManage.add(new ApplicationBuilder((EntitySpec)Preconditions.checkNotNull(appSpec, (Object)"appSpec")){

            protected void doBuild() {
            }
        });
        return this;
    }

    public BrooklynLauncher application(String yaml) {
        this.yamlAppsToManage.add(yaml);
        return this;
    }

    public BrooklynLauncher location(Location location) {
        this.locations.add((Location)Preconditions.checkNotNull((Object)location, (Object)"location"));
        return this;
    }

    public BrooklynLauncher location(String spec) {
        this.locationSpecs.add((String)Preconditions.checkNotNull((Object)spec, (Object)"spec"));
        return this;
    }

    public BrooklynLauncher locations(List<String> specs) {
        this.locationSpecs.addAll((Collection)Preconditions.checkNotNull(specs, (Object)"specs"));
        return this;
    }

    public BrooklynLauncher persistenceLocation(@Nullable String persistenceLocationSpec) {
        this.persistenceLocation = persistenceLocationSpec;
        return this;
    }

    public BrooklynLauncher globalBrooklynPropertiesFile(String file) {
        this.globalBrooklynPropertiesFile = file;
        return this;
    }

    public BrooklynLauncher localBrooklynPropertiesFile(String file) {
        this.localBrooklynPropertiesFile = file;
        return this;
    }

    public BrooklynLauncher managementContext(ManagementContext context) {
        if (this.brooklynProperties != null) {
            throw new IllegalStateException("Cannot set brooklynProperties and managementContext");
        }
        this.managementContext = context;
        return this;
    }

    public BrooklynLauncher brooklynProperties(BrooklynProperties brooklynProperties) {
        if (this.managementContext != null) {
            throw new IllegalStateException("Cannot set brooklynProperties and managementContext");
        }
        if (this.brooklynProperties != null && brooklynProperties != null && this.brooklynProperties != brooklynProperties) {
            LOG.warn("Brooklyn properties being reset in " + this + "; set null first if you wish to clear it", new Throwable("Source of brooklyn properties reset"));
        }
        this.brooklynProperties = brooklynProperties;
        return this;
    }

    public BrooklynLauncher brooklynProperties(String field, Object value) {
        this.brooklynAdditionalProperties.put((String)Preconditions.checkNotNull((Object)field, (Object)"field"), value);
        return this;
    }

    public <T> BrooklynLauncher brooklynProperties(ConfigKey<T> key, T value) {
        return this.brooklynProperties(key.getName(), value);
    }

    public BrooklynLauncher webconsole(boolean startWebApps) {
        this.startWebApps = startWebApps;
        return this;
    }

    public BrooklynLauncher installSecurityFilter(Boolean val) {
        this.skipSecurityFilter = val == null ? null : Boolean.valueOf(val == false);
        return this;
    }

    public BrooklynLauncher webconsolePort(int port) {
        return this.webconsolePort(PortRanges.fromInteger((int)port));
    }

    public BrooklynLauncher webconsolePort(String port) {
        if (port == null) {
            return this.webconsolePort((PortRange)null);
        }
        return this.webconsolePort(PortRanges.fromString((String)port));
    }

    public BrooklynLauncher webconsolePort(PortRange port) {
        this.port = port;
        return this;
    }

    public BrooklynLauncher webconsoleHttps(Boolean useHttps) {
        this.useHttps = useHttps;
        return this;
    }

    public BrooklynLauncher bindAddress(InetAddress bindAddress) {
        this.bindAddress = bindAddress;
        return this;
    }

    public BrooklynLauncher publicAddress(InetAddress publicAddress) {
        this.publicAddress = publicAddress;
        return this;
    }

    public BrooklynLauncher webServerFlags(Map<String, ?> webServerFlags) {
        this.webconsoleFlags = webServerFlags;
        return this;
    }

    public BrooklynLauncher webapp(String contextPath, String warUrl) {
        this.webApps.put(contextPath, warUrl);
        return this;
    }

    public BrooklynLauncher ignorePersistenceErrors(boolean ignorePersistenceErrors) {
        this.ignorePersistenceErrors = ignorePersistenceErrors;
        return this;
    }

    public BrooklynLauncher ignoreCatalogErrors(boolean ignoreCatalogErrors) {
        this.ignoreCatalogErrors = ignoreCatalogErrors;
        return this;
    }

    public BrooklynLauncher ignoreWebErrors(boolean ignoreWebErrors) {
        this.ignoreWebErrors = ignoreWebErrors;
        return this;
    }

    public BrooklynLauncher ignoreAppErrors(boolean ignoreAppErrors) {
        this.ignoreAppErrors = ignoreAppErrors;
        return this;
    }

    public BrooklynLauncher stopWhichAppsOnShutdown(StopWhichAppsOnShutdown stopWhich) {
        this.stopWhichAppsOnShutdown = stopWhich;
        return this;
    }

    public BrooklynLauncher customizeManagement(Function<ManagementContext, Void> customizeManagement) {
        this.customizeManagement = customizeManagement;
        return this;
    }

    @Beta
    public BrooklynLauncher catalogInitialization(CatalogInitialization catInit) {
        if (this.catalogInitialization != null) {
            throw new IllegalStateException("Initial catalog customization already set.");
        }
        this.catalogInitialization = catInit;
        return this;
    }

    public BrooklynLauncher shutdownOnExit(boolean val) {
        LOG.warn("Call to deprecated `shutdownOnExit`", new Throwable("source of deprecated call"));
        this.stopWhichAppsOnShutdown = StopWhichAppsOnShutdown.THESE_IF_NOT_PERSISTED;
        return this;
    }

    public BrooklynLauncher persistMode(PersistMode persistMode) {
        this.persistMode = persistMode;
        return this;
    }

    public BrooklynLauncher highAvailabilityMode(HighAvailabilityMode highAvailabilityMode) {
        this.highAvailabilityMode = highAvailabilityMode;
        return this;
    }

    public BrooklynLauncher persistenceDir(@Nullable String persistenceDir) {
        this.persistenceDir = persistenceDir;
        return this;
    }

    public BrooklynLauncher persistenceDir(@Nullable File persistenceDir) {
        if (persistenceDir == null) {
            return this.persistenceDir((String)null);
        }
        return this.persistenceDir(persistenceDir.getAbsolutePath());
    }

    public BrooklynLauncher persistPeriod(Duration persistPeriod) {
        this.persistPeriod = persistPeriod;
        return this;
    }

    public BrooklynLauncher haHeartbeatTimeout(Duration val) {
        this.haHeartbeatTimeoutOverride = val;
        return this;
    }

    public BrooklynLauncher startBrooklynNode(boolean val) {
        this.startBrooklynNode = val;
        return this;
    }

    public BrooklynLauncher haHeartbeatPeriod(Duration val) {
        this.haHeartbeatPeriodOverride = val;
        return this;
    }

    public void copyPersistedState(String destinationDir) {
        this.copyPersistedState(destinationDir, null, null);
    }

    public void copyPersistedState(String destinationDir, @Nullable String destinationLocation) {
        this.copyPersistedState(destinationDir, destinationLocation, null);
    }

    public void copyPersistedState(String destinationDir, @Nullable String destinationLocationSpec, @Nullable CompoundTransformer transformer) {
        this.initManagementContext();
        try {
            this.highAvailabilityMode = HighAvailabilityMode.HOT_STANDBY;
            this.initPersistence();
        }
        catch (Exception e) {
            this.handleSubsystemStartupError(this.ignorePersistenceErrors, "persistence", e);
        }
        try {
            BrooklynMementoRawData memento = this.managementContext.getRebindManager().retrieveMementoRawData();
            if (transformer != null) {
                memento = transformer.transform(memento);
            }
            ManagementPlaneSyncRecord planeState = this.managementContext.getHighAvailabilityManager().loadManagementPlaneSyncRecord(true);
            LOG.info("Persisting state to " + destinationDir + (destinationLocationSpec != null ? " @ " + destinationLocationSpec : ""));
            PersistenceObjectStore destinationObjectStore = BrooklynPersistenceUtils.newPersistenceObjectStore((ManagementContext)this.managementContext, (String)destinationLocationSpec, (String)destinationDir);
            BrooklynPersistenceUtils.writeMemento((ManagementContext)this.managementContext, (BrooklynMementoRawData)memento, (PersistenceObjectStore)destinationObjectStore);
            BrooklynPersistenceUtils.writeManagerMemento((ManagementContext)this.managementContext, (ManagementPlaneSyncRecord)planeState, (PersistenceObjectStore)destinationObjectStore);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            LOG.debug("Error copying persisted state (rethrowing): " + e, (Throwable)e);
            throw new FatalRuntimeException("Error copying persisted state: " + Exceptions.collapseText((Throwable)e), (Throwable)e);
        }
    }

    @Deprecated
    public BrooklynMementoRawData retrieveState() {
        this.initManagementContext();
        this.initPersistence();
        return this.managementContext.getRebindManager().retrieveMementoRawData();
    }

    @Deprecated
    public void persistState(BrooklynMementoRawData memento, String destinationDir, @Nullable String destinationLocationSpec) {
        this.initManagementContext();
        PersistenceObjectStore destinationObjectStore = BrooklynPersistenceUtils.newPersistenceObjectStore((ManagementContext)this.managementContext, (String)destinationLocationSpec, (String)destinationDir);
        BrooklynPersistenceUtils.writeMemento((ManagementContext)this.managementContext, (BrooklynMementoRawData)memento, (PersistenceObjectStore)destinationObjectStore);
    }

    public BrooklynLauncher start() {
        if (this.started) {
            throw new IllegalStateException("Cannot start() or launch() multiple times");
        }
        this.started = true;
        this.initManagementContext();
        CatalogInitialization catInit = ((ManagementContextInternal)this.managementContext).getCatalogInitialization();
        catInit.setStartingUp(true);
        if (this.startWebApps) {
            try {
                this.startWebApps();
            }
            catch (Exception e) {
                this.handleSubsystemStartupError(this.ignoreWebErrors, "core web apps", e);
            }
        }
        this.campPlatform = new BrooklynCampPlatformLauncherNoServer().useManagementContext(this.managementContext).launch().getCampPlatform();
        try {
            this.initPersistence();
            this.startPersistence();
        }
        catch (Exception e) {
            this.handleSubsystemStartupError(this.ignorePersistenceErrors, "persistence", e);
        }
        try {
            if (catInit != null && !catInit.hasRunOfficialInitialization()) {
                if (this.persistMode == PersistMode.DISABLED) {
                    LOG.debug("Loading catalog as part of launch sequence (it was not loaded as part of any rebind sequence)");
                    catInit.populateCatalog(ManagementNodeState.MASTER, true, true, null);
                } else {
                    ManagementNodeState state = this.managementContext.getHighAvailabilityManager().getNodeState();
                    LOG.warn("Loading catalog for " + state + " as part of launch sequence (it was not loaded as part of the rebind sequence)");
                    catInit.populateCatalog(state, true, true, null);
                }
            }
        }
        catch (Exception e) {
            this.handleSubsystemStartupError(this.ignoreCatalogErrors, "initial catalog", e);
        }
        catInit.setStartingUp(false);
        this.locations.addAll(this.managementContext.getLocationRegistry().resolve(this.locationSpecs));
        ((LocalManagementContext)this.managementContext).noteStartupComplete();
        try {
            this.createApps();
            this.startApps();
        }
        catch (Exception e) {
            this.handleSubsystemStartupError(this.ignoreAppErrors, "brooklyn autostart apps", e);
        }
        if (this.startBrooklynNode) {
            try {
                this.startBrooklynNode();
            }
            catch (Exception e) {
                this.handleSubsystemStartupError(this.ignoreAppErrors, "brooklyn node / self entity", e);
            }
        }
        if (this.persistMode != PersistMode.DISABLED) {
            this.managementContext.getRebindManager().forcePersistNow(false, null);
        }
        return this;
    }

    private void initManagementContext() {
        if (this.managementContext == null) {
            if (this.brooklynProperties == null) {
                BrooklynProperties.Factory.Builder builder = BrooklynProperties.Factory.builderDefault();
                if (this.globalBrooklynPropertiesFile != null) {
                    if (this.fileExists(this.globalBrooklynPropertiesFile)) {
                        LOG.debug("Using global properties file " + this.globalBrooklynPropertiesFile);
                        this.checkFileReadable(this.globalBrooklynPropertiesFile);
                        this.checkFilePermissionsX00(this.globalBrooklynPropertiesFile);
                    } else {
                        LOG.debug("Global properties file " + this.globalBrooklynPropertiesFile + " does not exist, will ignore");
                    }
                    builder.globalPropertiesFile(this.globalBrooklynPropertiesFile);
                } else {
                    LOG.debug("Global properties file disabled");
                    builder.globalPropertiesFile(null);
                }
                if (this.localBrooklynPropertiesFile != null) {
                    this.checkFileReadable(this.localBrooklynPropertiesFile);
                    this.checkFilePermissionsX00(this.localBrooklynPropertiesFile);
                    builder.localPropertiesFile(this.localBrooklynPropertiesFile);
                }
                this.managementContext = new LocalManagementContext(builder, this.brooklynAdditionalProperties);
            } else {
                if (this.globalBrooklynPropertiesFile != null) {
                    LOG.warn("Ignoring globalBrooklynPropertiesFile " + this.globalBrooklynPropertiesFile + " because explicit brooklynProperties supplied");
                }
                if (this.localBrooklynPropertiesFile != null) {
                    LOG.warn("Ignoring localBrooklynPropertiesFile " + this.localBrooklynPropertiesFile + " because explicit brooklynProperties supplied");
                }
                this.managementContext = new LocalManagementContext(this.brooklynProperties, this.brooklynAdditionalProperties);
            }
            this.brooklynProperties = ((ManagementContextInternal)this.managementContext).getBrooklynProperties();
            BrooklynShutdownHooks.invokeTerminateOnShutdown((ManagementContext)this.managementContext);
        } else if (this.brooklynProperties == null) {
            this.brooklynProperties = ((ManagementContextInternal)this.managementContext).getBrooklynProperties();
            this.brooklynProperties.addFromMap(this.brooklynAdditionalProperties);
        }
        if (this.catalogInitialization != null) {
            ((ManagementContextInternal)this.managementContext).setCatalogInitialization(this.catalogInitialization);
        }
        if (this.customizeManagement != null) {
            this.customizeManagement.apply((Object)this.managementContext);
        }
    }

    private boolean fileExists(String file) {
        return new File(Os.tidyPath((String)file)).exists();
    }

    private void checkFileReadable(String file) {
        File f = new File(Os.tidyPath((String)file));
        if (!f.exists()) {
            throw new FatalRuntimeException("File " + file + " does not exist");
        }
        if (!f.isFile()) {
            throw new FatalRuntimeException(file + " is not a file");
        }
        if (!f.canRead()) {
            throw new FatalRuntimeException(file + " is not readable");
        }
    }

    private void checkFilePermissionsX00(String file) {
        File f = new File(Os.tidyPath((String)file));
        Maybe permission = FileUtil.getFilePermissions((File)f);
        if (permission.isAbsent()) {
            LOG.debug("Could not determine permissions of file; assuming ok: " + f);
        } else if (!((String)permission.get()).subSequence(4, 10).equals("------")) {
            throw new FatalRuntimeException("Invalid permissions for file " + file + "; expected ?00 but was " + (String)permission.get());
        }
    }

    private void handleSubsystemStartupError(boolean ignoreSuchErrors, String system, Exception e) {
        Exceptions.propagateIfFatal((Throwable)e);
        if (ignoreSuchErrors) {
            LOG.error("Subsystem for " + system + " had startup error (continuing with startup): " + e, (Throwable)e);
            if (this.managementContext != null) {
                ((ManagementContextInternal)this.managementContext).errors().add(e);
            }
        } else {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    protected void startWebApps() {
        if (Boolean.TRUE.equals(this.skipSecurityFilter) && this.bindAddress == null) {
            LOG.info("Starting Brooklyn web-console on loopback because security is explicitly disabled and no bind address specified");
            this.bindAddress = Networking.LOOPBACK;
        } else if (BrooklynWebConfig.hasNoSecurityOptions((ConfigMap)this.brooklynProperties)) {
            if (this.bindAddress == null) {
                LOG.info("Starting Brooklyn web-console with passwordless access on localhost and protected access from any other interfaces (no bind address specified)");
            } else if (Arrays.equals(new byte[]{127, 0, 0, 1}, this.bindAddress.getAddress())) {
                LOG.info("Starting Brooklyn web-console with passwordless access on localhost");
            } else if (Arrays.equals(new byte[]{0, 0, 0, 0}, this.bindAddress.getAddress())) {
                LOG.info("Starting Brooklyn web-console with passwordless access on localhost and random password (logged) required from any other interfaces");
            } else {
                LOG.info("Starting Brooklyn web-console with passwordless access on localhost (if permitted) and random password (logged) required from any other interfaces");
            }
            this.brooklynProperties.put(BrooklynWebConfig.SECURITY_PROVIDER_CLASSNAME, (Object)BrooklynUserWithRandomPasswordSecurityProvider.class.getName());
        } else {
            LOG.debug("Starting Brooklyn using security properties: " + this.brooklynProperties.submap(ConfigPredicates.startingWith((String)"brooklyn.webconsole.security")).asMapWithStringKeys());
        }
        if (this.bindAddress == null) {
            this.bindAddress = Networking.ANY_NIC;
        }
        LOG.debug("Starting Brooklyn web-console with bindAddress " + this.bindAddress + " and properties " + this.brooklynProperties);
        try {
            this.webServer = new BrooklynWebServer(this.webconsoleFlags, this.managementContext);
            this.webServer.setBindAddress(this.bindAddress);
            this.webServer.setPublicAddress(this.publicAddress);
            if (this.port != null) {
                this.webServer.setPort(this.port);
            }
            if (this.useHttps != null) {
                this.webServer.setHttpsEnabled(this.useHttps);
            }
            this.webServer.putAttributes((Map)this.brooklynProperties);
            if (this.skipSecurityFilter != Boolean.TRUE) {
                this.webServer.setSecurityFilter(BrooklynPropertiesSecurityFilter.class);
            }
            for (Map.Entry<String, String> webapp : this.webApps.entrySet()) {
                this.webServer.addWar(webapp.getKey(), webapp.getValue());
            }
            this.webServer.start();
        }
        catch (Exception e) {
            LOG.warn("Failed to start Brooklyn web-console (rethrowing): " + Exceptions.collapseText((Throwable)e));
            throw new FatalRuntimeException("Failed to start Brooklyn web-console: " + Exceptions.collapseText((Throwable)e), (Throwable)e);
        }
    }

    protected void initPersistence() {
        ManagementPlaneSyncRecordPersisterToObjectStore persister;
        PersistenceObjectStore objectStore;
        if (this.persistMode == PersistMode.DISABLED) {
            LOG.info("Persistence disabled");
            objectStore = null;
        } else {
            try {
                if (this.persistenceLocation == null) {
                    this.persistenceLocation = (String)this.brooklynProperties.getConfig(BrooklynServerConfig.PERSISTENCE_LOCATION_SPEC);
                }
                this.persistenceDir = BrooklynServerPaths.newMainPersistencePathResolver((StringConfigMap)this.brooklynProperties).location(this.persistenceLocation).dir(this.persistenceDir).resolve();
                objectStore = BrooklynPersistenceUtils.newPersistenceObjectStore((ManagementContext)this.managementContext, (String)this.persistenceLocation, (String)this.persistenceDir, (PersistMode)this.persistMode, (HighAvailabilityMode)this.highAvailabilityMode);
                RebindManager rebindManager = this.managementContext.getRebindManager();
                persister = new BrooklynMementoPersisterToObjectStore(objectStore, (StringConfigMap)((ManagementContextInternal)this.managementContext).getBrooklynProperties(), this.managementContext.getCatalogClassLoader());
                PersistenceExceptionHandler persistenceExceptionHandler = PersistenceExceptionHandlerImpl.builder().build();
                ((RebindManagerImpl)rebindManager).setPeriodicPersistPeriod(this.persistPeriod);
                rebindManager.setPersister((BrooklynMementoPersister)persister, persistenceExceptionHandler);
            }
            catch (FatalConfigurationRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                LOG.debug("Error initializing persistence subsystem (rethrowing): " + e, (Throwable)e);
                throw new FatalRuntimeException("Error initializing persistence subsystem: " + Exceptions.collapseText((Throwable)e), (Throwable)e);
            }
        }
        if (this.highAvailabilityMode == HighAvailabilityMode.DISABLED) {
            LOG.info("High availability disabled");
        } else {
            if (objectStore == null) {
                throw new FatalConfigurationRuntimeException("Cannot run in HA mode when no persistence configured.");
            }
            HighAvailabilityManager haManager = this.managementContext.getHighAvailabilityManager();
            persister = new ManagementPlaneSyncRecordPersisterToObjectStore(this.managementContext, objectStore, this.managementContext.getCatalogClassLoader());
            ((HighAvailabilityManagerImpl)haManager).setHeartbeatTimeout(this.haHeartbeatTimeoutOverride);
            ((HighAvailabilityManagerImpl)haManager).setPollPeriod(this.haHeartbeatPeriodOverride);
            haManager.setPersister((ManagementPlaneSyncRecordPersister)persister);
        }
    }

    protected void startPersistence() {
        if (this.highAvailabilityMode == HighAvailabilityMode.DISABLED) {
            HighAvailabilityManager haManager = this.managementContext.getHighAvailabilityManager();
            haManager.disabled();
            if (this.persistMode != PersistMode.DISABLED) {
                this.startPersistenceWithoutHA();
            }
        } else {
            HighAvailabilityMode startMode = null;
            switch (this.highAvailabilityMode) {
                case AUTO: 
                case MASTER: 
                case STANDBY: 
                case HOT_STANDBY: 
                case HOT_BACKUP: {
                    startMode = this.highAvailabilityMode;
                    break;
                }
                case DISABLED: {
                    throw new IllegalStateException("Unexpected code-branch for high availability mode " + this.highAvailabilityMode);
                }
            }
            if (startMode == null) {
                throw new IllegalStateException("Unexpected high availability mode " + this.highAvailabilityMode);
            }
            LOG.debug("Management node (with HA) starting");
            HighAvailabilityManager haManager = this.managementContext.getHighAvailabilityManager();
            haManager.start(startMode);
        }
    }

    private void startPersistenceWithoutHA() {
        RebindManager rebindManager = this.managementContext.getRebindManager();
        if (Strings.isNonBlank((CharSequence)this.persistenceLocation)) {
            LOG.info("Management node (no HA) rebinding to entities at " + this.persistenceLocation + " in " + this.persistenceDir);
        } else {
            LOG.info("Management node (no HA) rebinding to entities on file system in " + this.persistenceDir);
        }
        ClassLoader classLoader = this.managementContext.getCatalogClassLoader();
        try {
            rebindManager.rebind(classLoader, null, ManagementNodeState.MASTER);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            LOG.debug("Error rebinding to persisted state (rethrowing): " + e, (Throwable)e);
            throw new FatalRuntimeException("Error rebinding to persisted state: " + Exceptions.collapseText((Throwable)e), (Throwable)e);
        }
        rebindManager.startPersistence();
    }

    protected void createApps() {
        StartableApplication app;
        for (ApplicationBuilder appBuilder : this.appBuildersToManage) {
            app = appBuilder.manage(this.managementContext);
            this.apps.add((Application)app);
        }
        for (Application app2 : this.appsToManage) {
            Entities.startManagement((Application)app2, (ManagementContext)this.managementContext);
            this.apps.add(app2);
        }
        for (String blueprint : this.yamlAppsToManage) {
            app = this.getAppFromYaml(blueprint);
            this.apps.add((Application)app);
        }
    }

    protected void startBrooklynNode() {
        final String classpath = System.getenv("INITIAL_CLASSPATH");
        if (Strings.isBlank((CharSequence)classpath)) {
            LOG.warn("Cannot find INITIAL_CLASSPATH environment variable, skipping BrooklynNode entity creation");
            return;
        }
        if (this.webServer == null || !this.startWebApps) {
            LOG.info("Skipping BrooklynNode entity creation, BrooklynWebServer not running");
            return;
        }
        ApplicationBuilder brooklyn = new ApplicationBuilder(){

            protected void doBuild() {
                this.addChild((EntitySpec)EntitySpec.create(LocalBrooklynNode.class).configure(SoftwareProcess.ENTITY_STARTED, (Object)true).configure((ConfigKey.HasConfigKey)SoftwareProcess.RUN_DIR, (Object)System.getenv("ROOT")).configure((ConfigKey.HasConfigKey)SoftwareProcess.INSTALL_DIR, (Object)System.getenv("BROOKLYN_HOME")).configure((ConfigKey.HasConfigKey)BrooklynNode.ENABLED_HTTP_PROTOCOLS, (Object)ImmutableList.of((Object)(BrooklynLauncher.this.webServer.getHttpsEnabled() ? "https" : "http"))).configure((ConfigKey.HasConfigKey)(BrooklynLauncher.this.webServer.getHttpsEnabled() ? BrooklynNode.HTTPS_PORT : BrooklynNode.HTTP_PORT), (Object)PortRanges.fromInteger((int)BrooklynLauncher.this.webServer.getActualPort())).configure((ConfigKey.HasConfigKey)BrooklynNode.WEB_CONSOLE_BIND_ADDRESS, (Object)BrooklynLauncher.this.bindAddress).configure((ConfigKey.HasConfigKey)BrooklynNode.WEB_CONSOLE_PUBLIC_ADDRESS, (Object)BrooklynLauncher.this.publicAddress).configure((ConfigKey.HasConfigKey)BrooklynNode.CLASSPATH, (Object)Splitter.on((String)":").splitToList((CharSequence)classpath)).configure((ConfigKey.HasConfigKey)BrooklynNode.NO_WEB_CONSOLE_AUTHENTICATION, (Object)Boolean.TRUE.equals(BrooklynLauncher.this.skipSecurityFilter)).configure(BrooklynNode.NO_SHUTDOWN_ON_EXIT, (Object)(BrooklynLauncher.this.stopWhichAppsOnShutdown == StopWhichAppsOnShutdown.NONE ? 1 : 0)).displayName("Brooklyn Console"));
            }
        };
        LocationSpec spec = (LocationSpec)LocationSpec.create(LocalhostMachineProvisioningLocation.LocalhostMachine.class).displayName("Local Brooklyn");
        Location localhost = this.managementContext.getLocationManager().createLocation(spec);
        brooklyn.appDisplayName("Brooklyn").manage(this.managementContext).start((Collection)ImmutableList.of((Object)localhost));
    }

    protected Application getAppFromYaml(String input) {
        BrooklynAssemblyTemplateInstantiator instantiator;
        AssemblyTemplate at = this.campPlatform.pdp().registerDeploymentPlan((Reader)new StringReader(input));
        try {
            AssemblyTemplateInstantiator ati = (AssemblyTemplateInstantiator)at.getInstantiator().newInstance();
            if (!(ati instanceof BrooklynAssemblyTemplateInstantiator)) {
                throw new IllegalStateException("Cannot create application with instantiator: " + ati);
            }
            instantiator = (BrooklynAssemblyTemplateInstantiator)BrooklynAssemblyTemplateInstantiator.class.cast(ati);
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
        Application app = instantiator.create(at, this.campPlatform);
        return app;
    }

    protected void startApps() {
        if (this.stopWhichAppsOnShutdown == StopWhichAppsOnShutdown.ALL || this.stopWhichAppsOnShutdown == StopWhichAppsOnShutdown.ALL_IF_NOT_PERSISTED && this.persistMode == PersistMode.DISABLED) {
            BrooklynShutdownHooks.invokeStopAppsOnShutdown((ManagementContext)this.managementContext);
        }
        ArrayList appExceptions = Lists.newArrayList();
        for (Application app : this.apps) {
            if (!(app instanceof Startable)) continue;
            if (this.stopWhichAppsOnShutdown == StopWhichAppsOnShutdown.THESE || this.stopWhichAppsOnShutdown == StopWhichAppsOnShutdown.THESE_IF_NOT_PERSISTED && this.persistMode == PersistMode.DISABLED) {
                BrooklynShutdownHooks.invokeStopOnShutdown((Entity)app);
            }
            try {
                LOG.info("Starting brooklyn application {} in location{} {}", new Object[]{app, this.locations.size() != 1 ? "s" : "", this.locations});
                ((Startable)app).start(this.locations);
            }
            catch (Exception e) {
                LOG.error("Error starting " + app + ": " + Exceptions.collapseText((Throwable)e), Exceptions.getFirstInteresting((Throwable)e));
                appExceptions.add(Exceptions.collapse((Throwable)e));
                if (!Thread.currentThread().isInterrupted()) continue;
                LOG.error("Interrupted while starting applications; aborting");
                break;
            }
        }
        if (!appExceptions.isEmpty()) {
            Throwable t = Exceptions.create((Collection)appExceptions);
            throw new FatalRuntimeException("Error starting applications: " + Exceptions.collapseText((Throwable)t), t);
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public void terminate() {
        if (!this.started) {
            return;
        }
        if (this.webServer != null) {
            try {
                this.webServer.stop();
            }
            catch (Exception e) {
                LOG.warn("Error stopping web-server; continuing with termination", (Throwable)e);
            }
        }
        if (this.persistMode != PersistMode.DISABLED) {
            try {
                Stopwatch stopwatch = Stopwatch.createStarted();
                if (this.managementContext.getHighAvailabilityManager().getPersister() != null) {
                    this.managementContext.getHighAvailabilityManager().getPersister().waitForWritesCompleted(Duration.TEN_SECONDS);
                }
                this.managementContext.getRebindManager().waitForPendingComplete(Duration.TEN_SECONDS, true);
                LOG.info("Finished waiting for persist; took " + Time.makeTimeStringRounded((Stopwatch)stopwatch));
            }
            catch (RuntimeInterruptedException e) {
                Thread.currentThread().interrupt();
                LOG.warn("Persistence interrupted during shutdown: " + (Object)((Object)e), (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOG.warn("Persistence interrupted during shutdown: " + e, (Throwable)e);
            }
            catch (TimeoutException e) {
                LOG.warn("Timeout after 10 seconds waiting for persistence to write all data; continuing");
            }
        }
        if (this.managementContext instanceof ManagementContextInternal) {
            ((ManagementContextInternal)this.managementContext).terminate();
        }
        for (Location loc : this.locations) {
            if (!(loc instanceof Closeable)) continue;
            Streams.closeQuietly((Closeable)((Closeable)loc));
        }
    }
}

