/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.osgi.karaf;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.annotation.Effector;
import brooklyn.entity.annotation.EffectorParam;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.SoftwareProcessImpl;
import brooklyn.entity.java.JmxSupport;
import brooklyn.entity.osgi.karaf.KarafContainer;
import brooklyn.entity.osgi.karaf.KarafDriver;
import brooklyn.entity.trait.Startable;
import brooklyn.event.AttributeSensor;
import brooklyn.event.Sensor;
import brooklyn.event.SensorEvent;
import brooklyn.event.SensorEventListener;
import brooklyn.event.feed.ConfigToAttributes;
import brooklyn.event.feed.jmx.JmxAttributePollConfig;
import brooklyn.event.feed.jmx.JmxFeed;
import brooklyn.event.feed.jmx.JmxHelper;
import brooklyn.event.feed.jmx.JmxValueFunctions;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.os.Os;
import brooklyn.util.repeat.Repeater;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import org.osgi.jmx.JmxConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KarafContainerImpl
extends SoftwareProcessImpl
implements KarafContainer {
    private static final Logger LOG = LoggerFactory.getLogger(KarafContainerImpl.class);
    public static final String KARAF_ADMIN = "org.apache.karaf:type=admin,name=%s";
    public static final String KARAF_FEATURES = "org.apache.karaf:type=features,name=%s";
    public static final String OSGI_BUNDLE_STATE = "osgi.core:type=bundleState,version=1.5";
    public static final String OSGI_FRAMEWORK = "osgi.core:type=framework,version=1.5";
    public static final String OSGI_COMPENDIUM = "osgi.compendium:service=cm,version=1.3";
    protected JmxHelper jmxHelper;
    private JmxFeed jmxFeed;

    public Class<KarafDriver> getDriverInterface() {
        return KarafDriver.class;
    }

    public KarafDriver getDriver() {
        return (KarafDriver)super.getDriver();
    }

    public void init() {
        super.init();
        new JmxSupport((Entity)this, null).recommendJmxRmiCustomAgent();
    }

    protected void postDriverStart() {
        super.postDriverStart();
        this.uploadPropertyFiles((Map)this.getConfig((ConfigKey)NAMED_PROPERTY_FILES));
        this.jmxHelper = new JmxHelper((EntityLocal)this);
        this.jmxHelper.connect(0L);
    }

    protected void connectSensors() {
        super.connectSensors();
        this.setAttribute((AttributeSensor)JMX_CONTEXT, String.format("karaf-%s", this.getConfig(KARAF_NAME.getConfigKey())));
        ConfigToAttributes.apply((EntityLocal)this);
        ObjectName karafAdminObjectName = JmxHelper.createObjectName((String)String.format(KARAF_ADMIN, this.getConfig(KARAF_NAME.getConfigKey())));
        this.jmxFeed = JmxFeed.builder().entity((EntityLocal)this).helper(this.jmxHelper).period(500L, TimeUnit.MILLISECONDS).pollAttribute((JmxAttributePollConfig)((JmxAttributePollConfig)new JmxAttributePollConfig((AttributeSensor)KARAF_INSTANCES).objectName(karafAdminObjectName).attributeName("Instances").onSuccess((Function)new Function<Object, Map>(){

            public Map apply(Object input) {
                return JmxValueFunctions.tabularDataToMap((TabularData)((TabularData)input));
            }
        })).onException((Function)new Function<Exception, Map>(){

            public Map apply(Exception input) {
                if (Boolean.TRUE.equals(KarafContainerImpl.this.getAttribute(Startable.SERVICE_UP))) {
                    LOG.debug("Entity " + this + " is not reachable on JMX");
                    KarafContainerImpl.this.setAttribute(Startable.SERVICE_UP, false);
                }
                return null;
            }
        })).build();
        this.subscribe((Entity)this, (Sensor)KARAF_INSTANCES, (SensorEventListener)new SensorEventListener<Map>(){

            public void onEvent(SensorEvent<Map> event) {
                Map map = (Map)event.getValue();
                if (map == null) {
                    return;
                }
                KarafContainerImpl.this.setAttribute(Startable.SERVICE_UP, "Started".equals(map.get("State")));
                KarafContainerImpl.this.setAttribute((AttributeSensor)KarafContainer.KARAF_ROOT, (Boolean)map.get("Is Root"));
                KarafContainerImpl.this.setAttribute((AttributeSensor)KarafContainer.KARAF_JAVA_OPTS, (String)map.get("JavaOpts"));
                KarafContainerImpl.this.setAttribute((AttributeSensor)KarafContainer.KARAF_INSTALL_LOCATION, (String)map.get("Location"));
                KarafContainerImpl.this.setAttribute((AttributeSensor)KarafContainer.KARAF_NAME, (String)map.get("Name"));
                KarafContainerImpl.this.setAttribute((AttributeSensor)KarafContainer.KARAF_PID, (Integer)map.get("Pid"));
                KarafContainerImpl.this.setAttribute((AttributeSensor)KarafContainer.KARAF_SSH_PORT, (Integer)map.get("Ssh Port"));
                KarafContainerImpl.this.setAttribute((AttributeSensor)KarafContainer.KARAF_RMI_REGISTRY_PORT, (Integer)map.get("RMI Registry Port"));
                KarafContainerImpl.this.setAttribute((AttributeSensor)KarafContainer.KARAF_RMI_SERVER_PORT, (Integer)map.get("RMI Server Port"));
                KarafContainerImpl.this.setAttribute((AttributeSensor)KarafContainer.KARAF_STATE, (String)map.get("State"));
            }
        });
    }

    protected void disconnectSensors() {
        super.disconnectSensors();
        if (this.jmxFeed != null) {
            this.jmxFeed.stop();
        }
    }

    protected void preStop() {
        super.preStop();
        if (this.jmxHelper != null) {
            this.jmxHelper.terminate();
        }
    }

    @Override
    @Effector(description="Updates the OSGi Service's properties, adding (and overriding) the given key-value pairs")
    public void updateServiceProperties(@EffectorParam(name="serviceName", description="Name of the OSGi service") String serviceName, Map<String, String> additionalVals) {
        TabularData table = (TabularData)this.jmxHelper.operation(OSGI_COMPENDIUM, "getProperties", new Object[]{serviceName});
        try {
            for (Map.Entry<String, String> entry : additionalVals.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                CompositeDataSupport data = new CompositeDataSupport(JmxConstants.PROPERTY_TYPE, (Map<String, ?>)MutableMap.of((Object)"Key", (Object)key, (Object)"Type", (Object)"String", (Object)"Value", (Object)value));
                table.remove(data.getAll(new String[]{"Key"}));
                table.put(data);
            }
        }
        catch (OpenDataException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        LOG.info("Updating monterey-service configuration with changes {}", additionalVals);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Updating monterey-service configuration with new configuration {}", (Object)table);
        }
        this.jmxHelper.operation(OSGI_COMPENDIUM, "update", new Object[]{serviceName, table});
    }

    @Override
    @Effector(description="Updates the OSGi Service's properties, adding (and overriding) the given key-value pairs")
    public void installFeature(final @EffectorParam(name="featureName", description="Name of the feature - see org.apache.karaf:type=features#installFeature()") String featureName) throws Exception {
        LOG.info("Installing feature {} via JMX", (Object)featureName);
        Repeater.create((String)("Wait for Karaf, to install feature " + featureName)).limitIterationsTo(40).every(500L, TimeUnit.MILLISECONDS).until((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                KarafContainerImpl.this.jmxHelper.operation(String.format(KarafContainerImpl.KARAF_FEATURES, KarafContainerImpl.this.getConfig(KarafContainer.KARAF_NAME.getConfigKey())), "installFeature", new Object[]{featureName});
                return true;
            }
        }).rethrowException().run();
    }

    @Override
    public Map<Long, Map<String, ?>> listBundles() {
        TabularData table = (TabularData)this.jmxHelper.operation(OSGI_BUNDLE_STATE, "listBundles", new Object[0]);
        Map map = JmxValueFunctions.tabularDataToMapOfMaps((TabularData)table);
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Map.Entry entry : map.entrySet()) {
            result.put((Long)((List)entry.getKey()).get(0), entry.getValue());
        }
        return result;
    }

    @Override
    @Effector(description="Deploys the given bundle, returning the bundle id - see osgi.core:type=framework#installBundle()")
    public long installBundle(@EffectorParam(name="bundle", description="URI of bundle to be deployed") String bundle) throws URISyntaxException {
        URI uri = new URI(bundle);
        boolean wrap = false;
        if ("wrap".equals(uri.getScheme())) {
            bundle = bundle.substring("wrap".length() + 1);
            uri = new URI(bundle);
            wrap = true;
        }
        if ("file".equals(uri.getScheme())) {
            LOG.info("Deploying bundle {} via file copy", (Object)bundle);
            File source = new File(uri);
            String target = this.getDriver().getRunDir() + "/" + source.getName();
            this.getDriver().copyResource(source, target);
            return (Long)this.jmxHelper.operation(OSGI_FRAMEWORK, "installBundle", new Object[]{(wrap ? "wrap:" : "") + "file" + "://" + target});
        }
        LOG.info("Deploying bundle {} via JMX", (Object)bundle);
        return (Long)this.jmxHelper.operation(OSGI_FRAMEWORK, "installBundle", new Object[]{(wrap ? "wrap:" : "") + bundle});
    }

    @Override
    @Effector(description="Undeploys the bundle with the given id")
    public void uninstallBundle(@EffectorParam(name="bundleId", description="Id of the bundle") Long bundleId) {
        this.jmxHelper.operation(OSGI_FRAMEWORK, "uninstallBundle", new Object[]{bundleId});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void uploadPropertyFiles(Map<String, Map<String, String>> propertyFiles) {
        if (propertyFiles == null) {
            return;
        }
        for (Map.Entry<String, Map<String, String>> entry : propertyFiles.entrySet()) {
            String file = entry.getKey();
            Map<String, String> contents = entry.getValue();
            Properties props = new Properties();
            for (Map.Entry<String, String> prop : contents.entrySet()) {
                props.setProperty(prop.getKey(), prop.getValue());
            }
            File local = Os.writePropertiesToTempFile((Properties)props, (String)("karaf-" + this.getId()), (String)".cfg");
            local.setReadable(true);
            try {
                String remote = this.getDriver().getRunDir() + "/" + file;
                this.getDriver().copyResource(local, remote);
            }
            finally {
                local.delete();
            }
        }
    }
}

