/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.osgi.karaf;

import brooklyn.catalog.Catalog;
import brooklyn.config.ConfigKey;
import brooklyn.entity.annotation.Effector;
import brooklyn.entity.annotation.EffectorParam;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.MethodEffector;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.java.UsesJava;
import brooklyn.entity.java.UsesJmx;
import brooklyn.entity.osgi.karaf.KarafContainerImpl;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.event.basic.BasicAttributeSensor;
import brooklyn.event.basic.BasicAttributeSensorAndConfigKey;
import brooklyn.event.basic.MapConfigKey;
import brooklyn.event.basic.PortAttributeSensorAndConfigKey;
import brooklyn.util.flags.SetFromFlag;
import java.net.URISyntaxException;
import java.util.Map;

@Catalog(name="Karaf", description="Apache Karaf is a small OSGi based runtime which provides a lightweight container onto which various components and applications can be deployed.", iconUrl="classpath:///karaf-logo.png")
@ImplementedBy(value=KarafContainerImpl.class)
public interface KarafContainer
extends SoftwareProcess,
UsesJava,
UsesJmx {
    public static final String WRAP_SCHEME = "wrap";
    public static final String FILE_SCHEME = "file";
    public static final String MVN_SCHEME = "mvn";
    public static final String HTTP_SCHEME = "http";
    public static final MethodEffector<Map<Long, Map<String, ?>>> LIST_BUNDLES = new MethodEffector(KarafContainer.class, "listBundles");
    public static final MethodEffector<Long> INSTALL_BUNDLE = new MethodEffector(KarafContainer.class, "installBundle");
    public static final MethodEffector<Void> UNINSTALL_BUNDLE = new MethodEffector(KarafContainer.class, "uninstallBundle");
    public static final MethodEffector<Void> INSTALL_FEATURE = new MethodEffector(KarafContainer.class, "installFeature");
    public static final MethodEffector<Void> UPDATE_SERVICE_PROPERTIES = new MethodEffector(KarafContainer.class, "updateServiceProperties");
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.SUGGESTED_VERSION, (Object)"2.3.0");
    @SetFromFlag(value="downloadUrl")
    public static final BasicAttributeSensorAndConfigKey<String> DOWNLOAD_URL = new BasicAttributeSensorAndConfigKey(SoftwareProcess.DOWNLOAD_URL, (Object)"http://apache.mirror.anlx.net/karaf/${version}/apache-karaf-${version}.tar.gz");
    @SetFromFlag(value="karafName")
    public static final BasicAttributeSensorAndConfigKey<String> KARAF_NAME = new BasicAttributeSensorAndConfigKey(String.class, "karaf.name", "Karaf instance name", (Object)"root");
    public static final MapConfigKey<Map<String, String>> NAMED_PROPERTY_FILES = new MapConfigKey(Map.class, "karaf.runtime.files", "Property files to be generated, referenced by name relative to runDir");
    @SetFromFlag(value="jmxUser")
    public static final BasicAttributeSensorAndConfigKey<String> JMX_USER = new BasicAttributeSensorAndConfigKey(UsesJmx.JMX_USER, (Object)"karaf");
    @SetFromFlag(value="jmxPassword")
    public static final BasicAttributeSensorAndConfigKey<String> JMX_PASSWORD = new BasicAttributeSensorAndConfigKey(UsesJmx.JMX_PASSWORD, (Object)"karaf");
    @SetFromFlag(value="jmxPort")
    public static final PortAttributeSensorAndConfigKey JMX_PORT = new PortAttributeSensorAndConfigKey(UsesJmx.JMX_PORT, (Object)"44444+");
    @SetFromFlag(value="rmiRegistryPort")
    public static final PortAttributeSensorAndConfigKey RMI_REGISTRY_PORT = UsesJmx.RMI_REGISTRY_PORT;
    @SetFromFlag(value="jmxContext")
    public static final BasicAttributeSensorAndConfigKey<String> JMX_CONTEXT = new BasicAttributeSensorAndConfigKey(UsesJmx.JMX_CONTEXT, (Object)("karaf-" + (String)KARAF_NAME.getConfigKey().getDefaultValue()));
    public static final BasicAttributeSensor<Map> KARAF_INSTANCES = new BasicAttributeSensor(Map.class, "karaf.admin.instances", "Karaf admin instances");
    public static final BasicAttributeSensor<Boolean> KARAF_ROOT = new BasicAttributeSensor(Boolean.class, "karaf.admin.isRoot", "Karaf admin isRoot");
    public static final BasicAttributeSensor<String> KARAF_JAVA_OPTS = new BasicAttributeSensor(String.class, "karaf.admin.java_opts", "Karaf Java opts");
    public static final BasicAttributeSensor<String> KARAF_INSTALL_LOCATION = new BasicAttributeSensor(String.class, "karaf.admin.location", "Karaf install location");
    public static final BasicAttributeSensor<Integer> KARAF_PID = new BasicAttributeSensor(Integer.class, "karaf.admin.pid", "Karaf instance PID");
    public static final BasicAttributeSensor<Integer> KARAF_SSH_PORT = new BasicAttributeSensor(Integer.class, "karaf.admin.ssh_port", "Karaf SSH Port");
    public static final BasicAttributeSensor<Integer> KARAF_RMI_REGISTRY_PORT = new BasicAttributeSensor(Integer.class, "karaf.admin.rmi_registry_port", "Karaf instance RMI registry port");
    public static final BasicAttributeSensor<Integer> KARAF_RMI_SERVER_PORT = new BasicAttributeSensor(Integer.class, "karaf.admin.rmi_server_port", "Karaf RMI (JMX) server port");
    public static final BasicAttributeSensor<String> KARAF_STATE = new BasicAttributeSensor(String.class, "karaf.admin.state", "Karaf instance state");

    @Effector(description="Updates the OSGi Service's properties, adding (and overriding) the given key-value pairs")
    public void updateServiceProperties(@EffectorParam(name="serviceName", description="Name of the OSGi service") String var1, Map<String, String> var2);

    @Effector(description="Installs the given OSGi feature")
    public void installFeature(@EffectorParam(name="featureName", description="Name of the feature - see org.apache.karaf:type=features#installFeature()") String var1) throws Exception;

    @Effector(description="Lists all the karaf bundles")
    public Map<Long, Map<String, ?>> listBundles();

    @Effector(description="Deploys the given bundle, returning the bundle id - see osgi.core:type=framework#installBundle()")
    public long installBundle(@EffectorParam(name="bundle", description="URI of bundle to be deployed") String var1) throws URISyntaxException;

    @Effector(description="Undeploys the bundle with the given id")
    public void uninstallBundle(@EffectorParam(name="bundleId", description="Id of the bundle") Long var1);
}

