/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.ec2;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.ec2.EC2ApiMetadata;
import org.jclouds.ec2.compute.EC2ComputeServiceContext;
import org.jclouds.ec2.compute.config.EC2ResolveImagesModule;
import org.jclouds.openstack.nova.ec2.NovaEC2Api;
import org.jclouds.openstack.nova.ec2.config.HyphenToNullIso8601Module;
import org.jclouds.openstack.nova.ec2.config.NovaEC2ComputeServiceContextModule;
import org.jclouds.openstack.nova.ec2.config.NovaEC2HttpApiModule;
import org.jclouds.rest.internal.BaseHttpApiMetadata;

@AutoService(value=ApiMetadata.class)
public final class NovaEC2ApiMetadata
extends BaseHttpApiMetadata<NovaEC2Api> {
    public Builder toBuilder() {
        return (Builder)new Builder().fromApiMetadata((ApiMetadata)this);
    }

    public NovaEC2ApiMetadata() {
        super((BaseHttpApiMetadata.Builder)new Builder());
    }

    protected NovaEC2ApiMetadata(Builder builder) {
        super((BaseHttpApiMetadata.Builder)builder);
    }

    public static Properties defaultProperties() {
        Properties properties = EC2ApiMetadata.defaultProperties();
        properties.setProperty("jclouds.regions", "nova");
        properties.setProperty("jclouds.ec2.ami-owners", "admin");
        properties.setProperty("jclouds.compute.resourcename-delimiter", "-");
        properties.setProperty("jclouds.relax-hostname", "true");
        properties.setProperty("jclouds.trust-all-certs", "true");
        properties.setProperty("jclouds.ec2.auto-allocate-elastic-ips", "true");
        properties.setProperty("jclouds.ssh.max-retries", "7");
        properties.setProperty("jclouds.ssh.retry-auth", "true");
        return properties;
    }

    public static final class Builder
    extends BaseHttpApiMetadata.Builder<NovaEC2Api, Builder> {
        public Builder() {
            ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id("openstack-nova-ec2")).name("OpenStack Nova's EC2-clone API")).version("2009-04-04")).identityName("Access Key ID")).credentialName("Secret Access Key")).defaultEndpoint("http://localhost:8773/services/Cloud")).documentation(URI.create("http://docs.amazonwebservices.com/AWSEC2/latest/APIReference"))).defaultProperties(NovaEC2ApiMetadata.defaultProperties())).view(EC2ComputeServiceContext.class)).defaultModules((Set)ImmutableSet.builder().add(NovaEC2HttpApiModule.class).add(EC2ResolveImagesModule.class).add(NovaEC2ComputeServiceContextModule.class).add(HyphenToNullIso8601Module.class).build());
        }

        public NovaEC2ApiMetadata build() {
            return new NovaEC2ApiMetadata(this);
        }

        protected Builder self() {
            return this;
        }
    }
}

