/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain.regionscoped;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;

public class RegionAndName {
    public static final Function<RegionAndName, String> NAME_FUNCTION = new Function<RegionAndName, String>(){

        public String apply(RegionAndName input) {
            return input.getName();
        }
    };
    public static final Function<RegionAndName, String> REGION_FUNCTION = new Function<RegionAndName, String>(){

        public String apply(RegionAndName input) {
            return input.getRegion();
        }
    };
    protected final String regionId;
    protected final String name;

    public static RegionAndName fromSlashEncoded(String name) {
        Iterable parts = Splitter.on((char)'/').split((CharSequence)Preconditions.checkNotNull((Object)name, (Object)"name"));
        Preconditions.checkArgument((Iterables.size((Iterable)parts) == 2 ? 1 : 0) != 0, (Object)"name must be in format regionId/name");
        return new RegionAndName((String)Iterables.get((Iterable)parts, (int)0), (String)Iterables.get((Iterable)parts, (int)1));
    }

    public static RegionAndName fromRegionAndName(String regionId, String name) {
        return new RegionAndName(regionId, name);
    }

    private static String slashEncodeRegionAndName(String regionId, String name) {
        return (String)Preconditions.checkNotNull((Object)regionId, (Object)"regionId") + "/" + (String)Preconditions.checkNotNull((Object)name, (Object)"name");
    }

    public String slashEncode() {
        return RegionAndName.slashEncodeRegionAndName(this.regionId, this.name);
    }

    protected RegionAndName(String regionId, String name) {
        this.regionId = (String)Preconditions.checkNotNull((Object)regionId, (Object)"regionId");
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
    }

    public String getRegion() {
        return this.regionId;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegionAndName that = (RegionAndName)RegionAndName.class.cast(o);
        return Objects.equal((Object)this.regionId, (Object)that.regionId) && Objects.equal((Object)this.name, (Object)that.name);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.regionId, this.name});
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("regionId", (Object)this.regionId).add("name", (Object)this.name);
    }

    public String toString() {
        return this.string().toString();
    }
}

