/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingObject;
import java.beans.ConstructorProperties;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.net.domain.IpProtocol;
import org.jclouds.openstack.nova.v2_0.domain.Ingress;
import org.jclouds.openstack.nova.v2_0.domain.TenantIdAndName;

public class SecurityGroupRule
extends Ingress {
    private final String id;
    private final TenantIdAndName group;
    @Named(value="parent_group_id")
    private final String parentGroupId;
    @Named(value="ip_range")
    private final Cidr ipRange;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromSecurityGroupRule(this);
    }

    @ConstructorProperties(value={"ip_protocol", "from_port", "to_port", "id", "group", "parent_group_id", "ip_range"})
    protected SecurityGroupRule(IpProtocol ipProtocol, int fromPort, int toPort, String id, @Nullable TenantIdAndName group, String parentGroupId, @Nullable Cidr ipRange) {
        super(ipProtocol, fromPort, toPort);
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.group = group;
        this.parentGroupId = (String)Preconditions.checkNotNull((Object)parentGroupId, (Object)"parentGroupId");
        this.ipRange = ipRange;
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public TenantIdAndName getGroup() {
        return this.group;
    }

    public String getParentGroupId() {
        return this.parentGroupId;
    }

    @Nullable
    public String getIpRange() {
        return this.ipRange == null ? null : this.ipRange.cidr;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.group, this.parentGroupId, this.ipRange});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SecurityGroupRule that = (SecurityGroupRule)SecurityGroupRule.class.cast(obj);
        return super.equals(that) && Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.group, (Object)that.group) && Objects.equal((Object)this.parentGroupId, (Object)that.parentGroupId) && Objects.equal((Object)((Object)this.ipRange), (Object)((Object)that.ipRange));
    }

    @Override
    protected Objects.ToStringHelper string() {
        return super.string().add("id", (Object)this.id).add("group", (Object)this.group).add("parentGroupId", (Object)this.parentGroupId).add("ipRange", (Object)this.ipRange);
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Ingress.Builder<T> {
        protected String id;
        protected TenantIdAndName group;
        protected String parentGroupId;
        protected String ipRange;

        public T id(String id) {
            this.id = id;
            return (T)((Builder)this.self());
        }

        public T group(TenantIdAndName group) {
            this.group = group;
            return (T)((Builder)this.self());
        }

        public T parentGroupId(String parentGroupId) {
            this.parentGroupId = parentGroupId;
            return (T)((Builder)this.self());
        }

        public T ipRange(String ipRange) {
            this.ipRange = ipRange;
            return (T)((Builder)this.self());
        }

        @Override
        public SecurityGroupRule build() {
            return new SecurityGroupRule(this.ipProtocol, this.fromPort, this.toPort, this.id, this.group, this.parentGroupId, this.ipRange == null ? null : new Cidr(this.ipRange));
        }

        public T fromSecurityGroupRule(SecurityGroupRule in) {
            return ((Builder)((Builder)((Builder)((Builder)super.fromIngress(in)).id(in.getId())).group(in.getGroup())).parentGroupId(in.getParentGroupId())).ipRange(in.getIpRange());
        }
    }

    public static class Cidr
    extends ForwardingObject {
        private String cidr;

        @ConstructorProperties(value={"cidr"})
        protected Cidr(String cidr) {
            this.cidr = (String)Preconditions.checkNotNull((Object)cidr);
        }

        protected Object delegate() {
            return this.cidr;
        }
    }
}

