/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import java.beans.ConstructorProperties;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.net.domain.IpProtocol;

@Beta
public class Ingress {
    @Named(value="ip_protocol")
    private final IpProtocol ipProtocol;
    @Named(value="from_port")
    private final int fromPort;
    @Named(value="to_port")
    private final int toPort;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromIngress(this);
    }

    @ConstructorProperties(value={"ip_protocol", "from_port", "to_port"})
    protected Ingress(@Nullable IpProtocol ipProtocol, int fromPort, int toPort) {
        this.ipProtocol = ipProtocol == null ? IpProtocol.UNRECOGNIZED : ipProtocol;
        this.fromPort = fromPort;
        this.toPort = toPort;
    }

    public IpProtocol getIpProtocol() {
        return this.ipProtocol;
    }

    public int getFromPort() {
        return this.fromPort;
    }

    public int getToPort() {
        return this.toPort;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.ipProtocol, this.fromPort, this.toPort});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Ingress that = (Ingress)Ingress.class.cast(obj);
        return Objects.equal((Object)this.ipProtocol, (Object)that.ipProtocol) && Objects.equal((Object)this.fromPort, (Object)that.fromPort) && Objects.equal((Object)this.toPort, (Object)that.toPort);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("ipProtocol", (Object)this.ipProtocol).add("fromPort", this.fromPort).add("toPort", this.toPort);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected IpProtocol ipProtocol;
        protected int fromPort;
        protected int toPort;

        protected abstract T self();

        public T ipProtocol(IpProtocol ipProtocol) {
            this.ipProtocol = ipProtocol;
            return this.self();
        }

        public T fromPort(int fromPort) {
            this.fromPort = fromPort;
            return this.self();
        }

        public T toPort(int toPort) {
            this.toPort = toPort;
            return this.self();
        }

        public Ingress build() {
            return new Ingress(this.ipProtocol, this.fromPort, this.toPort);
        }

        public T fromIngress(Ingress in) {
            return ((Builder)((Builder)this.ipProtocol(in.getIpProtocol())).fromPort(in.getFromPort())).toPort(in.getToPort());
        }
    }
}

