/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.loaders;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheLoader;
import com.google.common.util.concurrent.Atomics;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionAndName;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionSecurityGroupNameAndPorts;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.SecurityGroupInRegion;

public class FindSecurityGroupOrCreate
extends CacheLoader<RegionAndName, SecurityGroupInRegion> {
    protected final Predicate<AtomicReference<RegionAndName>> returnSecurityGroupExistsInRegion;
    protected final Function<RegionSecurityGroupNameAndPorts, SecurityGroupInRegion> groupCreator;

    @Inject
    public FindSecurityGroupOrCreate(@Named(value="SECURITYGROUP_PRESENT") Predicate<AtomicReference<RegionAndName>> returnSecurityGroupExistsInRegion, Function<RegionSecurityGroupNameAndPorts, SecurityGroupInRegion> groupCreator) {
        this.returnSecurityGroupExistsInRegion = (Predicate)Preconditions.checkNotNull(returnSecurityGroupExistsInRegion, (Object)"returnSecurityGroupExistsInRegion");
        this.groupCreator = (Function)Preconditions.checkNotNull(groupCreator, (Object)"groupCreator");
    }

    public SecurityGroupInRegion load(RegionAndName in) {
        AtomicReference securityGroupInRegionRef = Atomics.newReference((Object)Preconditions.checkNotNull((Object)in, (Object)"regionSecurityGroupNameAndPorts"));
        if (this.returnSecurityGroupExistsInRegion.apply((Object)securityGroupInRegionRef)) {
            return this.returnExistingSecurityGroup(securityGroupInRegionRef);
        }
        return this.createNewSecurityGroup(in);
    }

    private SecurityGroupInRegion returnExistingSecurityGroup(AtomicReference<RegionAndName> securityGroupInRegionRef) {
        RegionAndName securityGroupInRegion = securityGroupInRegionRef.get();
        Preconditions.checkState((boolean)(securityGroupInRegion instanceof SecurityGroupInRegion), (String)"programming error: predicate %s should update the atomic reference to the actual security group found", (Object[])new Object[]{this.returnSecurityGroupExistsInRegion});
        return (SecurityGroupInRegion)SecurityGroupInRegion.class.cast(securityGroupInRegion);
    }

    private SecurityGroupInRegion createNewSecurityGroup(RegionAndName in) {
        Preconditions.checkState((boolean)(Preconditions.checkNotNull((Object)in, (Object)"regionSecurityGroupNameAndPorts") instanceof RegionSecurityGroupNameAndPorts), (String)"programming error: when issuing get to this cacheloader, you need to pass an instance of RegionSecurityGroupNameAndPorts, not %s", (Object[])new Object[]{in});
        RegionSecurityGroupNameAndPorts regionSecurityGroupNameAndPorts = (RegionSecurityGroupNameAndPorts)RegionSecurityGroupNameAndPorts.class.cast(in);
        return (SecurityGroupInRegion)this.groupCreator.apply((Object)regionSecurityGroupNameAndPorts);
    }

    public String toString() {
        return "returnExistingSecurityGroupInRegionOrCreateAsNeeded()";
    }
}

