/*
 * Decompiled with CFR 0.152.
 */
package eu.seaclouds.common.tosca;

import alien4cloud.model.components.CSARDependency;
import alien4cloud.model.topology.Topology;
import alien4cloud.tosca.model.ArchiveRoot;
import alien4cloud.tosca.parser.ParsingException;
import alien4cloud.tosca.parser.ParsingResult;
import alien4cloud.tosca.parser.ToscaParser;
import alien4cloud.tosca.serializer.VelocityUtil;
import com.google.common.base.Supplier;
import eu.seaclouds.common.tosca.ToscaParserSupplier;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToscaSerializer {
    static Logger log = LoggerFactory.getLogger(ToscaSerializer.class);
    public static final String TEMPLATE_VERSION = "1.0.0-SNAPSHOT";
    private static Supplier<ToscaParser> p = new Supplier<ToscaParser>(){

        public ToscaParser get() {
            return new ToscaParserSupplier().get();
        }
    };

    public static String toTOSCA(Topology topology, String author, String name, String description) {
        topology.getDependencies().add(new CSARDependency("tosca-normative-types", "1.0.0.wd03-SNAPSHOT"));
        HashMap<String, Object> velocityCtx = new HashMap<String, Object>();
        velocityCtx.put("topology", topology);
        velocityCtx.put("template_name", name);
        velocityCtx.put("template_version", TEMPLATE_VERSION);
        velocityCtx.put("template_author", author);
        velocityCtx.put("template_description", description);
        StringWriter writer = new StringWriter();
        try {
            VelocityUtil.generate((String)"topology-1_0_0_wd03.yml.vm", (Writer)writer, velocityCtx);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception generating the yaml");
        }
        return writer.toString();
    }

    public static ParsingResult<ArchiveRoot> fromTOSCA(Path filePath) throws ParsingException {
        ToscaParser parser = (ToscaParser)p.get();
        ParsingResult parsingResult = parser.parseFile(filePath);
        return parsingResult;
    }

    public static ParsingResult<ArchiveRoot> fromTOSCA(String yaml) throws ParsingException, IOException {
        log.debug("Parsing: \n" + yaml);
        File tempFile = File.createTempFile("toscayamlFile", null);
        BufferedWriter bw = new BufferedWriter(new FileWriter(tempFile));
        bw.write(yaml);
        bw.close();
        ToscaParser parser = (ToscaParser)p.get();
        ParsingResult parsingResult = parser.parseFile(Paths.get(tempFile.getAbsolutePath(), new String[0]));
        tempFile.delete();
        return parsingResult;
    }
}

