/*
 * Decompiled with CFR 0.152.
 */
package eu.seaclouds.platform.planner.aamwriter.modeldesigner;

import eu.seaclouds.platform.planner.aamwriter.modeldesigner.DGraph;
import org.json.simple.JSONObject;

public class DRequirements {
    private DGraph graph;
    private double responseTime;
    private double availability;
    private double cost;
    private double workload;
    private String frontendModuleName;

    public DRequirements(JSONObject jnode, DGraph graph) {
        this.graph = graph;
        this.responseTime = this.parseDouble(jnode, "response_time");
        this.availability = this.parseDouble(jnode, "availability");
        this.cost = this.parseDouble(jnode, "cost");
        this.workload = this.parseDouble(jnode, "workload");
        this.frontendModuleName = this.parseString(jnode, "frontend");
    }

    private double parseDouble(JSONObject jnode, String key) {
        Object value = jnode.get((Object)key);
        double result = value == null ? 0.0 : Double.parseDouble(value.toString());
        return result;
    }

    private String parseString(JSONObject jnode, String key) {
        Object value = jnode.get((Object)key);
        String result = value == null ? "" : value.toString();
        return result;
    }

    public String toString() {
        return String.format("DRequirements [responseTime=%s, availability=%s, cost=%s, workload=%s]", this.responseTime, this.availability, this.cost, this.workload);
    }

    public double getResponseTime() {
        return this.responseTime;
    }

    public double getAvailability() {
        return this.availability;
    }

    public double getCost() {
        return this.cost;
    }

    public double getWorkload() {
        return this.workload;
    }

    public String getFrontend() {
        return this.frontendModuleName;
    }

    public static final class Attributes {
        public static final String RESPONSE_TIME = "response_time";
        public static final String AVAILABILITY = "availability";
        public static final String COST = "cost";
        public static final String WORKLOAD = "workload";
        public static final String FRONTEND = "frontend";
    }
}

