/*
 * Decompiled with CFR 0.152.
 */
package eu.seaclouds.platform.planner.aamwriter.modeldesigner;

import eu.seaclouds.platform.planner.aamwriter.modeldesigner.DGraph;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONObject;

public class DNode {
    public static final DNode NOT_FOUND = new DNode("[null]", "[null]");
    private DGraph graph;
    private String name;
    private String type;
    private Map<String, Object> properties;
    private String language;
    private String minVersion;
    private String maxVersion;
    private String category;
    private String artifact;
    private String infrastructure;
    private String container;
    private String numCpus;
    private String diskSize;
    private String benchmarkResponseTime;
    private String benchmarkPlatform;
    private List<Map<String, String>> qos;
    private boolean frontend;
    private String location;
    private String locationOption;

    public DNode(JSONObject jnode, DGraph graph) {
        this.graph = graph;
        this.name = (String)jnode.get((Object)"name");
        this.type = (String)jnode.get((Object)"type");
        this.properties = new HashMap<String, Object>();
        this.properties.putAll(this.readProperties(jnode));
    }

    private DNode(String name, String type) {
        this.name = name;
        this.type = type;
    }

    private Map<String, Object> readProperties(JSONObject jnode) {
        Map map = (Map)jnode.get((Object)"properties");
        this.language = this.extractStringFromMap("language", map);
        this.minVersion = this.extractStringFromMap("min_version", map);
        this.maxVersion = this.extractStringFromMap("max_version", map);
        this.category = this.extractStringFromMap("category", map);
        this.artifact = this.extractStringFromMap("artifact", map);
        this.infrastructure = this.extractStringFromMap("infrastructure", map);
        this.container = this.extractStringFromMap("container", map);
        this.numCpus = this.extractStringFromMap("num_cpus", map);
        this.diskSize = this.extractStringFromMap("disk_size", map);
        this.benchmarkResponseTime = this.extractStringFromMap("benchmark_rt", map);
        this.benchmarkPlatform = this.extractStringFromMap("benchmark_platform", map);
        this.qos = this.extractQosFromMap("qos", map);
        this.frontend = this.extractBooleanFromMap("frontend", map);
        this.location = this.extractStringFromMap("location", map);
        this.locationOption = this.extractStringFromMap("location_option", map);
        return map;
    }

    private String extractStringFromMap(String key, Map<String, Object> map) {
        String value = (String)map.remove(key);
        return value == null ? "" : value;
    }

    private boolean extractBooleanFromMap(String key, Map<String, Object> map) {
        Object value = map.remove(key);
        boolean result = false;
        if (value instanceof Boolean) {
            result = value != null && (Boolean)value != false;
        } else if (value instanceof String) {
            return "yes".equals(value);
        }
        return result;
    }

    private List<Object> extractListFromMap(String key, Map<String, Object> map) {
        List value = (List)map.remove(key);
        return value == null ? Collections.EMPTY_LIST : value;
    }

    private List<Map<String, String>> extractQosFromMap(String key, Map<String, Object> map) {
        List qos = (List)map.remove(key);
        if (qos != null) {
            for (Map listitem : qos) {
                for (String mapkey : listitem.keySet()) {
                    Object mapvalue = listitem.get(mapkey);
                    listitem.put(mapkey, mapvalue.toString());
                }
            }
        }
        return qos == null ? Collections.EMPTY_LIST : qos;
    }

    public String toString() {
        return String.format("Node [name=%s, type=%s, properties=%s]", this.name, this.type, this.properties);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DNode other = (DNode)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, Object> getOtherProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public String getLanguage() {
        return this.language;
    }

    public String getMinVersion() {
        return this.minVersion;
    }

    public String getMaxVersion() {
        return this.maxVersion;
    }

    public String getCategory() {
        return this.category;
    }

    public String getArtifact() {
        return this.artifact;
    }

    public String getInfrastructure() {
        return this.infrastructure;
    }

    public String getContainer() {
        return this.container;
    }

    public String getNumCpus() {
        return this.numCpus;
    }

    public String getDiskSize() {
        return this.diskSize;
    }

    public String getBenchmarkResponseTime() {
        return this.benchmarkResponseTime;
    }

    public String getBenchmarkPlatform() {
        return this.benchmarkPlatform;
    }

    public List<Map<String, String>> getQos() {
        return this.qos;
    }

    public boolean getFrontend() {
        return this.frontend;
    }

    public boolean isFrontend() {
        boolean result = false;
        if (this.graph != null) {
            result = this.graph.getFrontendNode() == this;
        }
        return result;
    }

    public String getLocation() {
        return this.location;
    }

    public String getLocationOption() {
        return this.locationOption;
    }

    public static final class Locations {
        public static final String STATIC = "STATIC";
        public static final String DYNAMIC = "DYNAMIC";
    }

    public static final class Containers {
        public static final String JBOSS6 = "webapp.jboss.JBoss6Server";
        public static final String JBOSS7 = "webapp.jboss.JBoss7Server";
        public static final String JETTY6 = "webapp.jetty.Jetty6Server";
        public static final String TOMCAT = "webapp.tomcat.TomcatServer";
        public static final String TOMCAT8 = "webapp.tomcat.Tomcat8Server";
    }

    public static final class Categories {
        public static final String MYSQL = "database.mysql.MySqlNode";
        public static final String MARIADB = "database.mariadb.MariaDbNode";
        public static final String POSTGRESQL = "database.postgresql.PostgreSqlNode";
        public static final String MONGODB = "nosql.mongodb.MongoDBServer";
        public static final String REDIS = "nosql.redis.RedisStore";
    }

    public static final class Types {
        public static final String WEB_APPLICATION = "WebApplication";
        public static final String DATABASE = "Database";
    }

    public static final class Attributes {
        public static final String NAME = "name";
        public static final String TYPE = "type";
        public static final String PROPERTIES = "properties";
    }
}

