/*
 * Decompiled with CFR 0.152.
 */
package eu.seaclouds.platform.planner.aamwriter.modeldesigner;

import eu.seaclouds.platform.planner.aamwriter.modeldesigner.DGraph;
import eu.seaclouds.platform.planner.aamwriter.modeldesigner.DNode;
import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONObject;

public class DLink {
    private DGraph graph;
    private DNode source;
    private DNode target;
    private Map<String, String> properties;
    private String calls;
    private String operationType;
    private String credentialsFile;
    private String envVar;

    public DLink(JSONObject jnode, DGraph graph) {
        this.graph = graph;
        String sourceName = (String)jnode.get((Object)"source");
        this.source = this.graph.getNode(sourceName);
        String targetName = (String)jnode.get((Object)"target");
        this.target = this.graph.getNode(targetName);
        Map linkProperties = (Map)jnode.get((Object)"properties");
        this.properties = new HashMap<String, String>();
        this.properties.putAll(linkProperties);
        this.calls = this.properties.containsKey("calls") ? this.properties.get("calls") : "";
        this.operationType = this.properties.containsKey("operation_type") ? this.properties.get("operation_type") : "";
        this.credentialsFile = this.properties.containsKey("credentials_file") ? this.properties.get("credentials_file") : "";
        this.envVar = this.properties.containsKey("env_var") ? this.properties.get("env_var") : "";
    }

    public String toString() {
        return String.format("Link [source=%s, target=%s, properties=%s]", this.source.getName(), this.target.getName(), this.properties);
    }

    public DNode getSource() {
        return this.source;
    }

    public DNode getTarget() {
        return this.target;
    }

    public String getCalls() {
        return this.calls;
    }

    public String getCredentialsFile() {
        return this.credentialsFile;
    }

    public String getOperationType() {
        return this.operationType;
    }

    public String getEnvVar() {
        return this.envVar;
    }

    public static final class Attributes {
        public static final String SOURCE = "source";
        public static final String TARGET = "target";
        public static final String PROPERTIES = "properties";
        public static final String CALLS = "calls";
        public static final String TYPE = "operation_type";
        public static final String CREDENTIALS_FILE = "credentials_file";
        public static final String ENV_VAR = "env_var";
    }
}

