/*
 * Decompiled with CFR 0.152.
 */
package eu.seaclouds.platform.planner.aamwriter.modeldesigner;

import eu.seaclouds.platform.planner.aamwriter.AamWriterException;
import eu.seaclouds.platform.planner.aamwriter.modeldesigner.DLink;
import eu.seaclouds.platform.planner.aamwriter.modeldesigner.DNode;
import eu.seaclouds.platform.planner.aamwriter.modeldesigner.DRequirements;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class DGraph {
    private String name;
    private List<DNode> nodes;
    private List<DLink> links;
    private DRequirements requirements;
    private DNode frontendNode;

    public DGraph(JSONObject json) {
        this.name = (String)json.get((Object)"name");
        this.nodes = new ArrayList<DNode>();
        JSONArray onodes = (JSONArray)json.get((Object)"nodes");
        this.nodes.addAll(this.parseArray(onodes, DNode.class));
        this.links = new ArrayList<DLink>();
        JSONArray olinks = (JSONArray)json.get((Object)"links");
        this.links.addAll(this.parseArray(olinks, DLink.class));
        JSONObject orequirements = (JSONObject)json.get((Object)"application_requirements");
        this.requirements = new DRequirements(orequirements, this);
        this.frontendNode = this.findFrontendNode();
    }

    public DNode getNode(String nodeName) {
        if (nodeName == null) {
            throw new NullPointerException("nodeName cannot be null");
        }
        for (DNode node : this.nodes) {
            if (!nodeName.equals(node.getName())) continue;
            return node;
        }
        return DNode.NOT_FOUND;
    }

    public List<DLink> getLinksFrom(DNode node) {
        if (node == null) {
            throw new NullPointerException("node cannot be null");
        }
        ArrayList<DLink> result = new ArrayList<DLink>();
        for (DLink link : this.links) {
            if (!node.equals(link.getSource())) continue;
            result.add(link);
        }
        return result;
    }

    public List<DLink> getLinksTo(DNode node) {
        if (node == null) {
            throw new NullPointerException("node cannot be null");
        }
        ArrayList<DLink> result = new ArrayList<DLink>();
        for (DLink link : this.links) {
            if (!node.equals(link.getTarget())) continue;
            result.add(link);
        }
        return result;
    }

    private <T> List<T> parseArray(JSONArray items, Class<T> clazz) {
        ArrayList<T> result = new ArrayList<T>();
        for (Object onode : items) {
            T item;
            JSONObject jnode = (JSONObject)onode;
            try {
                item = clazz.getDeclaredConstructor(JSONObject.class, DGraph.class).newInstance(jnode, this);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new AamWriterException(e);
            }
            result.add(item);
        }
        return result;
    }

    private DNode findFrontendNode() {
        DNode frontend = this.getNode(this.requirements.getFrontend());
        if (frontend == DNode.NOT_FOUND && (frontend = this.searchFrontendNode()) == DNode.NOT_FOUND) {
            frontend = this.calculateSourceNode();
        }
        return frontend;
    }

    private DNode searchFrontendNode() {
        DNode result = DNode.NOT_FOUND;
        for (DNode node : this.nodes) {
            if (!node.getFrontend()) continue;
            result = node;
            break;
        }
        return result;
    }

    private DNode calculateSourceNode() {
        DNode result = DNode.NOT_FOUND;
        for (DNode node : this.nodes) {
            List<DLink> links = this.getLinksTo(node);
            if (links.size() != 0) continue;
            result = node;
            break;
        }
        return result;
    }

    public String toString() {
        return String.format("Graph [name=%s, nodes=%s, links=%s, requirements=%s, source=%s]", this.name, Arrays.toString(this.nodes.toArray()), Arrays.toString(this.links.toArray()), this.requirements.toString(), this.frontendNode.getName());
    }

    public String getName() {
        return this.name;
    }

    public List<DNode> getNodes() {
        return this.nodes;
    }

    public List<DLink> getLinks() {
        return this.links;
    }

    public DRequirements getRequirements() {
        return this.requirements;
    }

    public DNode getFrontendNode() {
        return this.frontendNode;
    }

    public static final class Properties {
        public static final String NAME = "name";
        public static final String NODES = "nodes";
        public static final String LINKS = "links";
        public static final String REQUIREMENTS = "application_requirements";
    }
}

