/*
 * Decompiled with CFR 0.152.
 */
package eu.seaclouds.platform.planner.aamwriter.modelaam;

import eu.seaclouds.platform.planner.aamwriter.modelaam.Constraint;
import eu.seaclouds.platform.planner.aamwriter.modelaam.Operation;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public interface Policy {

    public static class ConstraintBuilder {
        private Constraint buildConstraint(String operator, double threshold, String unit) {
            Constraint c = "".equals(unit) ? new Constraint(operator, threshold) : new Constraint(operator, threshold + " " + unit);
            return c;
        }
    }

    public static class Dependency {
        private Operation operation;
        private String calls;

        public Dependency(Operation operation, String calls) {
            this.operation = operation;
            this.calls = calls;
        }

        public Operation getOperation() {
            return this.operation;
        }

        public String getCalls() {
            return this.calls;
        }
    }

    public static class Dependencies
    extends AbstractPolicy<String> {
        private static final long serialVersionUID = 1L;

        public Dependencies(List<Dependency> dependencies) {
            super("dependencies");
            for (Dependency dep : dependencies) {
                this.getProperties().put(dep.getOperation().getName(), dep.getCalls());
            }
        }

        public static class Attributes {
            public static final String NAME = "dependencies";
        }
    }

    public static class ModuleQoSRequirements
    extends AbstractPolicy<Constraint> {
        private static final long serialVersionUID = 1L;
        private ConstraintBuilder constraintBuilder = new ConstraintBuilder();

        public ModuleQoSRequirements() {
            super("QoSRequirements");
        }

        public void addConstraint(String metricName, String operator, double threshold, String unit) {
            this.getProperties().put(metricName, this.buildConstraint(operator, threshold, unit));
        }

        private Constraint buildConstraint(String operator, double threshold, String unit) {
            return this.constraintBuilder.buildConstraint(operator, threshold, unit);
        }

        public static class Attributes {
            public static final String NAME = "QoSRequirements";
        }
    }

    public static class AppQoSRequirements
    extends AbstractPolicy<Constraint> {
        private static final long serialVersionUID = 1L;
        private ConstraintBuilder constraintBuilder = new ConstraintBuilder();

        public AppQoSRequirements(double rt, double availability, double cost, double workload) {
            super("AppQoSRequirements");
            this.getProperties().put("response_time", this.buildConstraint("less_than", rt, "ms"));
            this.getProperties().put("availability", this.buildConstraint("greater_than", availability, ""));
            this.getProperties().put("cost", this.buildConstraint("less_or_equal", cost, "euros_per_month"));
            this.getProperties().put("workload", this.buildConstraint("less_or_equal", workload, "req_per_min"));
        }

        private Constraint buildConstraint(String operator, double threshold, String unit) {
            return this.constraintBuilder.buildConstraint(operator, threshold, unit);
        }

        public static class Attributes {
            public static final String NAME = "AppQoSRequirements";
            public static final String RESPONSE_TIME = "response_time";
            public static final String AVAILABILITY = "availability";
            public static final String COST = "cost";
            public static final String WORKLOAD = "workload";
        }
    }

    public static class QoSInfo
    extends AbstractPolicy<String> {
        private static final long serialVersionUID = 1L;

        public QoSInfo(String executionTimeInMs, String benchmarkPlatform) {
            super("QoSInfo");
            this.getProperties().put("execution_time", executionTimeInMs + " ms");
            this.getProperties().put("benchmark_platform", benchmarkPlatform);
        }

        public static class Attributes {
            public static final String NAME = "QoSInfo";
            public static final String EXECUTION_TIME = "execution_time";
            public static final String BENCHMARK_PLATFORM = "benchmark_platform";
        }
    }

    public static class AbstractPolicy<T>
    extends LinkedHashMap<String, Map<String, T>>
    implements Policy {
        private static final long serialVersionUID = 1L;
        private Map<String, T> _properties = new LinkedHashMap<String, T>();

        public AbstractPolicy(String name) {
            this.put(name, this._properties);
        }

        protected Map<String, T> getProperties() {
            return this._properties;
        }
    }
}

