/*
 * Decompiled with CFR 0.152.
 */
package eu.seaclouds.platform.planner.aamwriter.modelaam;

import eu.seaclouds.platform.planner.aamwriter.modelaam.Constraint;
import eu.seaclouds.platform.planner.aamwriter.modelaam.ConstraintProperty;
import eu.seaclouds.platform.planner.aamwriter.modelaam.NodeType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class NodeTemplate
extends LinkedHashMap {
    private static final long serialVersionUID = 1L;
    private String name;
    private Map _properties = new LinkedHashMap();
    private List<Map<String, String>> _artifacts = new ArrayList<Map<String, String>>();
    private List<Map<String, Object>> _requirements = new ArrayList<Map<String, Object>>();

    public NodeTemplate(String name) {
        this.name = name;
        this.setType("<notset>");
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return (String)this.get("type");
    }

    public void setType(String type) {
        this.put("type", type);
    }

    public void setType(NodeType type) {
        this.setType(type.getName());
    }

    public void addProperties(Map<String, Object> properties) {
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            this.properties().put(entry.getKey(), entry.getValue());
        }
    }

    public void addProperty(String name, String value) {
        this.properties().put(name, value);
    }

    public void addArtifact(String name, String value, String type) {
        LinkedHashMap<String, String> artifact = new LinkedHashMap<String, String>();
        artifact.put(name, value);
        artifact.put("type", type);
        this.artifacts().add(artifact);
    }

    public void setHostRequirement(NodeTemplate node) {
        for (Map<String, Object> item : this._requirements) {
            if (!item.containsKey("host")) continue;
            item.put("host", node.getName());
            return;
        }
        LinkedHashMap<String, String> requirement = new LinkedHashMap<String, String>();
        requirement.put("host", node.getName());
        this.requirements().add(requirement);
    }

    public String addConnectionRequirement(NodeTemplate target, String type, String varName) {
        LinkedHashMap requirement = new LinkedHashMap();
        String requirementName = "endpoint";
        LinkedHashMap<String, Object> requirementMap = new LinkedHashMap<String, Object>();
        requirement.put(requirementName, requirementMap);
        requirementMap.put("node", target.getName());
        requirementMap.put("type", type);
        if (!varName.isEmpty()) {
            LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
            properties.put("prop.name", varName);
            requirementMap.put("properties", properties);
        }
        this.requirements().add(requirement);
        return requirementName;
    }

    public void addConstrainedProperty(String propertyName, Constraint ... constraints) {
        ConstraintProperty constraintProperty = new ConstraintProperty();
        for (Constraint constraint : constraints) {
            if (constraint == null) continue;
            constraintProperty.addConstraint(constraint);
        }
        this.properties().put(propertyName, constraintProperty);
    }

    private Map properties() {
        if (!this.containsKey("properties")) {
            this.put("properties", this._properties);
        }
        return this._properties;
    }

    private List<Map<String, String>> artifacts() {
        if (!this.containsKey("artifacts")) {
            this.put("artifacts", this._artifacts);
        }
        return this._artifacts;
    }

    private List<Map<String, Object>> requirements() {
        if (!this.containsKey("requirements")) {
            this.put("requirements", this._requirements);
        }
        return this._requirements;
    }

    public static final class Attributes {
        public static final String TYPE = "type";
        public static final String PROPERTIES = "properties";
        public static final String ARTIFACTS = "artifacts";
        public static final String REQUIREMENTS = "requirements";
    }
}

