/*
 * Decompiled with CFR 0.152.
 */
package eu.seaclouds.platform.planner.aamwriter.modelaam;

import eu.seaclouds.platform.planner.aamwriter.modelaam.NodeType;
import eu.seaclouds.platform.planner.aamwriter.modelaam.Operation;
import eu.seaclouds.platform.planner.aamwriter.modelaam.TopologyTemplate;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class Aam
extends LinkedHashMap {
    private static final long serialVersionUID = 1L;
    private TopologyTemplate topology_template;
    private Map<String, NodeType> nodeTypes = new LinkedHashMap<String, NodeType>();
    private Map<String, Operation> groups = new LinkedHashMap<String, Operation>();

    public Aam(String description) {
        if (description == null) {
            throw new IllegalArgumentException("description cannot be null");
        }
        if ("".equals(description)) {
            description = "<description_not_set>";
        }
        this.put("tosca_definitions_version", "tosca_simple_yaml_1_0_0_wd03");
        this.put("description", description);
        ArrayList<String> imports = new ArrayList<String>();
        this.put("imports", imports);
        imports.add("tosca-normative-types:1.0.0.wd06-SNAPSHOT");
        this.topology_template = new TopologyTemplate();
        this.put("topology_template", this.topology_template);
        this.put("node_types", this.nodeTypes);
        this.put("groups", this.groups);
    }

    public TopologyTemplate getTopologyTemplate() {
        return this.topology_template;
    }

    public void addNodeType(NodeType node) {
        this.nodeTypes.put(node.getName(), node);
    }

    public void addOperation(Operation operation) {
        this.groups.put(operation.getName(), operation);
    }

    public Operation getOperation(String operationName) {
        return this.groups.get(operationName);
    }

    public NodeType getNodeType(String name) {
        return this.nodeTypes.get(name);
    }
}

