/*
 * Decompiled with CFR 0.152.
 */
package eu.seaclouds.platform.planner.aamwriter;

import eu.seaclouds.platform.planner.aamwriter.MonitoringMetrics;
import eu.seaclouds.platform.planner.aamwriter.modelaam.Aam;
import eu.seaclouds.platform.planner.aamwriter.modelaam.Constraint;
import eu.seaclouds.platform.planner.aamwriter.modelaam.NodeTemplate;
import eu.seaclouds.platform.planner.aamwriter.modelaam.NodeType;
import eu.seaclouds.platform.planner.aamwriter.modelaam.Operation;
import eu.seaclouds.platform.planner.aamwriter.modelaam.Policy;
import eu.seaclouds.platform.planner.aamwriter.modelaam.TopologyTemplate;
import eu.seaclouds.platform.planner.aamwriter.modeldesigner.DGraph;
import eu.seaclouds.platform.planner.aamwriter.modeldesigner.DLink;
import eu.seaclouds.platform.planner.aamwriter.modeldesigner.DNode;
import eu.seaclouds.platform.planner.aamwriter.modeldesigner.DRequirements;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Translator {
    public static Logger log = LoggerFactory.getLogger(Translator.class);
    private static final String NODE_TYPE_PREFIX = "sc_req.";
    private static final String OPERATION_PREFIX = "operation_";

    public Aam translate(DGraph graph) {
        Aam aam = new Aam(graph.getName());
        for (DNode n : graph.getNodes()) {
            this.translateDNode(n, aam);
        }
        for (DLink l : graph.getLinks()) {
            this.translateDLink(l, aam);
        }
        this.buildGroups(graph, aam);
        return aam;
    }

    private void translateDNode(DNode dnode, Aam aam) {
        Constraint[] constraints1;
        String prefix;
        boolean needsContainer;
        TopologyTemplate topology = aam.getTopologyTemplate();
        NodeTemplate module = new NodeTemplate(dnode.getName());
        topology.addNodeTemplate(module);
        boolean bl = needsContainer = !dnode.getContainer().isEmpty();
        if (!dnode.getLanguage().isEmpty()) {
            module.addProperty("language", dnode.getLanguage());
        }
        module.addProperties(dnode.getOtherProperties());
        String artifactValue = dnode.getArtifact();
        if (!artifactValue.isEmpty()) {
            String artifactName = this.buildArtifactName(dnode, needsContainer);
            String artifactType = "tosca.artifacts.File";
            module.addArtifact(artifactName, artifactValue, artifactType);
        }
        NodeType moduleType = new NodeType(NODE_TYPE_PREFIX + module.getName());
        String derivedFrom = this.buildDerivedFrom(dnode);
        moduleType.setDerivedFrom(derivedFrom);
        if (this.isPlatformEligible(dnode)) {
            ArrayList<Object> supportItems = new ArrayList<Object>();
            if (!"".equals(dnode.getLanguage())) {
                String prefix2 = this.getPrefixItem(dnode.getLanguage(), dnode.getMinVersion(), dnode.getMaxVersion());
                supportItems.add(prefix2);
            }
            if (!"".equals(dnode.getContainer())) {
                supportItems.add(this.getPrefixItem(dnode.getContainer(), "", ""));
            }
            if (!"".equals(dnode.getCategory())) {
                String prefix2 = this.getPrefixItem(dnode.getCategory(), dnode.getMinVersion(), dnode.getMaxVersion());
                supportItems.add(prefix2);
            }
            for (String string : supportItems) {
                if ("".equals(string)) continue;
                moduleType.addSupportItemConstraintProperty(string + "_support");
            }
            if ("STATIC".equals(dnode.getLocation())) {
                Constraint constraint = this.buildContinentConstraint(dnode.getLocationOption());
                moduleType.addConstrainedProperty("continent", constraint);
            }
        }
        if (this.isComputeEligible(dnode)) {
            Constraint constraint;
            if (!"".equals(dnode.getNumCpus())) {
                constraint = this.buildGreaterEqualsConstraint(dnode.getNumCpus());
                moduleType.addConstrainedProperty("num_cpus", constraint);
            }
            if (!"".equals(dnode.getDiskSize())) {
                constraint = this.buildGreaterEqualsConstraint(dnode.getDiskSize());
                moduleType.addConstrainedProperty("disk_size", constraint);
            }
            if ("STATIC".equals(dnode.getLocation())) {
                constraint = this.buildContinentConstraint(dnode.getLocationOption());
                moduleType.addConstrainedProperty("continent", constraint);
            }
        }
        if (!"".equals(dnode.getLanguage())) {
            prefix = this.getPrefixItem(dnode.getLanguage(), dnode.getMinVersion(), dnode.getMaxVersion());
            constraints1 = this.buildVersionConstraints(dnode);
            Constraint[] constraintArray = this.buildVersionConstraints(dnode);
            if (this.isPlatformEligible(dnode)) {
                moduleType.addConstrainedProperty(prefix + "_version", constraints1);
            }
            if (this.isComputeEligible(dnode)) {
                module.addConstrainedProperty(prefix + "_version", constraintArray);
            }
        }
        if (!"".equals(dnode.getCategory())) {
            prefix = this.getPrefixItem(dnode.getCategory(), dnode.getMinVersion(), dnode.getMaxVersion());
            constraints1 = this.buildVersionConstraints(dnode);
            Constraint[] constraintArray = this.buildVersionConstraints(dnode);
            if (this.isPlatformEligible(dnode)) {
                moduleType.addConstrainedProperty(prefix + "_version", constraints1);
            }
            if (this.isComputeEligible(dnode)) {
                module.addConstrainedProperty(prefix + "_version", constraintArray);
            }
        }
        aam.addNodeType(moduleType);
        moduleType.addResourceTypeConstraintProperty(dnode.getInfrastructure());
        module.setType(moduleType);
    }

    private void translateDLink(DLink l, Aam aam) {
        TopologyTemplate topologyTemplate = aam.getTopologyTemplate();
        DNode dSource = l.getSource();
        DNode dTarget = l.getTarget();
        NodeTemplate source = topologyTemplate.getNodeTemplate(dSource.getName());
        NodeTemplate target = topologyTemplate.getNodeTemplate(dTarget.getName());
        source.addConnectionRequirement(target, l.getOperationType(), l.getEnvVar());
    }

    private void buildGroups(DGraph dgraph, Aam aam) {
        for (DNode dnode : dgraph.getNodes()) {
            Operation operation = new Operation(this.buildOperationName(dnode), dnode.getName());
            aam.addOperation(operation);
        }
        for (DNode dnode : dgraph.getNodes()) {
            Operation sourceOperation = aam.getOperation(this.buildOperationName(dnode));
            if (!"".equals(dnode.getBenchmarkResponseTime()) && !"".equals(dnode.getBenchmarkPlatform())) {
                Policy.QoSInfo info = new Policy.QoSInfo(dnode.getBenchmarkResponseTime(), dnode.getBenchmarkPlatform());
                sourceOperation.addQoSInfo(info);
            }
            ArrayList<Policy.Dependency> dependencies = new ArrayList<Policy.Dependency>();
            for (DLink link : dgraph.getLinksFrom(dnode)) {
                Operation targetOperation = aam.getOperation(this.buildOperationName(link.getTarget()));
                Policy.Dependency dep = new Policy.Dependency(targetOperation, link.getCalls());
                dependencies.add(dep);
            }
            sourceOperation.addDependencies(new Policy.Dependencies(dependencies));
            if (dnode.isFrontend()) {
                DRequirements dreq = dgraph.getRequirements();
                Policy.AppQoSRequirements requirements = new Policy.AppQoSRequirements(dreq.getResponseTime(), dreq.getAvailability(), dreq.getCost(), dreq.getWorkload());
                sourceOperation.addAppQoSRequirement(requirements);
            }
            if (dnode.getQos().isEmpty()) continue;
            Policy.ModuleQoSRequirements requirements = this.buildModuleQoSRequirements(dnode.getQos());
            sourceOperation.addModuleQoSRequirement(requirements);
        }
    }

    private String buildDerivedFrom(DNode dnode) {
        String derivedFromSuffix = "WebApplication".equals(dnode.getType()) ? dnode.getContainer() : dnode.getCategory();
        String derivedFrom = derivedFromSuffix.isEmpty() ? "seaclouds.nodes.SoftwareComponent" : "seaclouds.nodes." + derivedFromSuffix;
        return derivedFrom;
    }

    private String buildArtifactName(DNode dnode, boolean needsContainer) {
        String artifactName;
        switch (dnode.getType()) {
            case "WebApplication": {
                String language = dnode.getLanguage();
                if ("JAVA".equals(language)) {
                    artifactName = needsContainer ? "wars.root" : "jar";
                    break;
                }
                if ("PHP".equals(language)) {
                    artifactName = dnode.getArtifact().endsWith(".git") ? "git.url" : "tarball.url";
                    break;
                }
                artifactName = "file";
                break;
            }
            case "Database": {
                artifactName = "database.mysql.MySqlNode".equals(dnode.getCategory()) ? "creationScriptUrl" : "db_create";
                break;
            }
            default: {
                artifactName = "artifact";
            }
        }
        return artifactName;
    }

    private String buildOperationName(DNode dnode) {
        return OPERATION_PREFIX + dnode.getName();
    }

    private boolean isComputeEligible(DNode dnode) {
        return "".equals(dnode.getInfrastructure()) || "compute".equals(dnode.getInfrastructure());
    }

    private boolean isPlatformEligible(DNode dnode) {
        return "".equals(dnode.getInfrastructure()) || "platform".equals(dnode.getInfrastructure());
    }

    private Constraint[] buildVersionConstraints(DNode dnode) {
        Constraint[] constraints = new Constraint[2];
        if (!"".equals(dnode.getMinVersion())) {
            constraints[0] = new Constraint("greater_or_equal", dnode.getMinVersion());
        }
        if (!"".equals(dnode.getMaxVersion())) {
            constraints[1] = new Constraint("less_or_equal", dnode.getMaxVersion());
        }
        return constraints;
    }

    private Constraint buildGreaterEqualsConstraint(String threshold) {
        Constraint result = new Constraint("greater_or_equal", threshold);
        return result;
    }

    private Constraint buildContinentConstraint(String continent) {
        Constraint result = new Constraint("equal", continent);
        return result;
    }

    private String getPrefixItem(String requirement, String minVersion, String maxVersion) {
        switch (requirement) {
            case "JAVA": {
                return "java";
            }
            case "PYTHON": {
                return "python";
            }
            case "RUBY": {
                return "ruby";
            }
            case ".NET": {
                return "dotnet";
            }
            case "PHP": {
                return "php";
            }
            case "webapp.jboss.JBoss6Server": {
                return "jboss";
            }
            case "webapp.jboss.JBoss7Server": {
                return "jboss";
            }
            case "webapp.jetty.Jetty6Server": {
                return "jetty";
            }
            case "webapp.tomcat.TomcatServer": {
                return "tomcat";
            }
            case "webapp.tomcat.Tomcat8Server": {
                return "tomcat";
            }
            case "database.mysql.MySqlNode": {
                return "mysql";
            }
            case "database.mariadb.MariaDbNode": {
                return "maria";
            }
            case "database.postgresql.PostgreSqlNode": {
                return "postgresql";
            }
            case "nosql.mongodb.MongoDBServer": {
                return "mongoDB";
            }
            case "nosql.redis.RedisStore": {
                return "redis";
            }
        }
        return "";
    }

    private Policy.ModuleQoSRequirements buildModuleQoSRequirements(List<Map<String, String>> qos) {
        Policy.ModuleQoSRequirements result = new Policy.ModuleQoSRequirements();
        for (Map<String, String> item : qos) {
            MonitoringMetrics metric = MonitoringMetrics.from(item.get("metric"));
            String metricName = metric.getMetricName();
            String operator = item.get("operator");
            String threshold = item.get("threshold");
            String unit = metric.getUnit();
            try {
                double thresholdValue = Double.parseDouble(threshold);
                result.addConstraint(metricName, operator, thresholdValue, unit);
            }
            catch (NumberFormatException e) {
                log.warn("Could not parse threshold value ('{}'). This QoS requirement is ignored", (Object)threshold);
            }
        }
        return result;
    }

    private static final class Languages {
        public static final String PHP = "PHP";
        public static final String NET = ".NET";
        public static final String RUBY = "RUBY";
        public static final String PYTHON = "PYTHON";
        public static final String JAVA = "JAVA";

        private Languages() {
        }
    }
}

