/*
 * Decompiled with CFR 0.152.
 */
package eu.seaclouds.platform.planner.aamwriter;

import eu.seaclouds.platform.planner.aamwriter.AamWriterException;
import eu.seaclouds.platform.planner.aamwriter.Translator;
import eu.seaclouds.platform.planner.aamwriter.Utils;
import eu.seaclouds.platform.planner.aamwriter.modelaam.Aam;
import eu.seaclouds.platform.planner.aamwriter.modeldesigner.DGraph;
import java.io.IOException;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class AamWriter {
    private Translator translator = new Translator();

    public static void main(String[] args) {
        JSONObject root;
        if (args.length == 0) {
            System.err.println("Usage: aamwriter <topology.json>");
            System.exit(1);
        }
        String path = args[0];
        AamWriter writer = new AamWriter();
        try {
            root = (JSONObject)Utils.loadJson(path);
        }
        catch (IOException | ParseException e) {
            throw new AamWriterException(e);
        }
        String yaml = writer.writeAam(root);
        System.out.println(yaml);
    }

    public String writeAam(String json) {
        JSONObject root = (JSONObject)JSONValue.parse((String)json);
        String yaml = this.writeAam(root);
        return yaml;
    }

    private String writeAam(JSONObject root) {
        DGraph graph = new DGraph(root);
        Aam aam = this.translator.translate(graph);
        String yaml = this.dumpYaml(aam);
        return yaml;
    }

    private String dumpYaml(Aam aam) {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yamlParser = new Yaml(options);
        String yamlString = yamlParser.dump((Object)aam);
        return yamlString;
    }
}

