/*
 * Decompiled with CFR 0.152.
 */
package rs.mail.queue;

import com.github.cowwoc.tokenbucket.Bucket;
import com.github.cowwoc.tokenbucket.ConsumptionResult;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs.mail.queue.MailQueueListener;
import rs.mail.queue.MailSender;

public class MailQueue<T> {
    public static final int DEFAULT_MAX_SIZE = 1000;
    public static final int DEFAULT_MAX_PRIORITY_SIZE = 50;
    public static final int DEFAULT_MAX_RETRIES = 3;
    public static final long DEFAULT_RETRY_PERIOD = 60000L;
    public static final long DEFAULT_QUEUING_TIMEOUT_SECONDS = 10L;
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private MailSender<T> mailSender;
    private LinkedBlockingDeque<MessageEntry<T>> queue;
    private LinkedBlockingDeque<MessageEntry<T>> priorityQueue;
    private int maxSize;
    private int maxPrioritySize;
    private Bucket tokenBucket;
    private int maxRetries;
    private long retryPeriod;
    private Set<MailQueueListener> listeners;

    public MailQueue(MailSender<T> mailSender) {
        this(mailSender, 1000, 50);
    }

    public MailQueue(MailSender<T> mailSender, int maxSize) {
        this(mailSender, maxSize, 50);
    }

    public MailQueue(MailSender<T> mailSender, int maxSize, int maxPrioritySize) {
        this.mailSender = mailSender;
        this.queue = new LinkedBlockingDeque(maxSize);
        this.priorityQueue = new LinkedBlockingDeque(maxPrioritySize);
        this.listeners = new HashSet<MailQueueListener>();
        this.maxRetries = 3;
        this.retryPeriod = 60000L;
        this.maxSize = maxSize;
        this.maxPrioritySize = maxPrioritySize;
    }

    public Bucket getTokenBucket() {
        return this.tokenBucket;
    }

    public void setTokenBucket(Bucket tokenBucket) {
        this.tokenBucket = tokenBucket;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public long getRetryPeriod() {
        return this.retryPeriod;
    }

    public void setRetryPeriod(long retryPeriod) {
        this.retryPeriod = retryPeriod;
    }

    public boolean queue(T message, String referenceId) {
        return this.queue(message, referenceId, false, 0, 0L);
    }

    public boolean queue(T message, String referenceId, long timeoutInSeconds) {
        return this.queue(message, referenceId, false, 0, timeoutInSeconds);
    }

    public boolean queue(T message, String referenceId, boolean isPriority) {
        return this.queue(message, referenceId, isPriority, 0, 0L);
    }

    public boolean queue(T message, String referenceId, boolean isPriority, long timeoutInSeconds) {
        return this.queue(message, referenceId, isPriority, 0, timeoutInSeconds);
    }

    public boolean queue(T message, String referenceId, boolean isPriority, int previousErrorCount) {
        return this.queue(message, referenceId, isPriority, previousErrorCount, 0L);
    }

    public boolean queue(T message, String referenceId, boolean isPriority, int previousErrorCount, long timeoutInSeconds) {
        MessageEntry<T> entry = new MessageEntry<T>(referenceId, message, isPriority);
        entry.failedAttempts = previousErrorCount;
        return this.queue(entry, isPriority ? this.priorityQueue : this.queue, timeoutInSeconds);
    }

    protected boolean queue(MessageEntry<T> message, LinkedBlockingDeque<MessageEntry<T>> queue, long timeoutInSeconds) {
        try {
            boolean rc = false;
            rc = timeoutInSeconds > 0L ? queue.offer(message, timeoutInSeconds, TimeUnit.SECONDS) : queue.offer(message);
            if (rc) {
                this.mailQueued(message);
            }
            return rc;
        }
        catch (InterruptedException e) {
            this.log.error("Queuing interrupted on " + message.referenceId, (Throwable)e);
            return false;
        }
    }

    public int size() {
        return this.size(true) + this.size(false);
    }

    public int size(boolean isPriority) {
        return isPriority ? this.priorityQueue.size() : this.queue.size();
    }

    public int capacity(boolean isPriority) {
        return isPriority ? this.maxPrioritySize : this.maxSize;
    }

    public int remainingCapacity(boolean isPriority) {
        return isPriority ? this.priorityQueue.remainingCapacity() : this.queue.remainingCapacity();
    }

    public void addListener(MailQueueListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(MailQueueListener listener) {
        this.listeners.remove(listener);
    }

    protected void mailQueued(MessageEntry<T> entry) {
        for (MailQueueListener listener : this.listeners) {
            listener.onQueued(entry.referenceId);
        }
    }

    protected void mailSending(MessageEntry<T> entry) {
        for (MailQueueListener listener : this.listeners) {
            listener.onSending(entry.referenceId);
        }
    }

    protected void mailSent(MessageEntry<T> entry) {
        for (MailQueueListener listener : this.listeners) {
            listener.onSent(entry.referenceId);
        }
    }

    protected void mailFailed(MessageEntry<T> entry, String reason) {
        for (MailQueueListener listener : this.listeners) {
            listener.onFailed(entry.referenceId, entry.failedAttempts, reason);
        }
    }

    public void run() throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("I have " + this.size() + " messages queued");
        }
        MessageEntry<T> candidate = this.getNext();
        while (candidate != null) {
            if (this.getBucketToken()) {
                this.mailSending(candidate);
                try {
                    this.mailSender.sendMessage(candidate.message, candidate.referenceId);
                    this.mailSent(candidate);
                    this.remove(candidate);
                }
                catch (Throwable t) {
                    ++candidate.failedAttempts;
                    this.mailFailed(candidate, t.getMessage());
                    this.log.error("Cannot send message", t);
                    if (candidate.failedAttempts > this.getMaxRetries()) {
                        this.remove(candidate);
                    }
                    candidate.notBeforeTimeInMillis = System.currentTimeMillis() + this.retryPeriod;
                }
                candidate = this.getNext();
                continue;
            }
            candidate = null;
        }
    }

    protected MessageEntry<T> getNext() {
        MessageEntry<T> rc = this.getNext(true);
        if (rc == null) {
            rc = this.getNext(false);
        }
        return rc;
    }

    protected MessageEntry<T> getNext(boolean isPriority) {
        Object[] list;
        long now = System.currentTimeMillis();
        LinkedBlockingDeque<MessageEntry<T>> queue = isPriority ? this.priorityQueue : this.queue;
        for (Object o : list = queue.toArray()) {
            MessageEntry entry = (MessageEntry)o;
            if (entry.notBeforeTimeInMillis >= now) continue;
            return entry;
        }
        return null;
    }

    protected void remove(MessageEntry<T> entry) {
        if (entry.isPriority) {
            this.priorityQueue.remove(entry);
        } else {
            this.queue.remove(entry);
        }
    }

    protected boolean getBucketToken() {
        if (this.tokenBucket != null) {
            ConsumptionResult result = this.tokenBucket.tryConsume();
            return result.getTokensConsumed() > 0L;
        }
        return true;
    }

    protected static class MessageEntry<X> {
        protected String referenceId;
        protected X message;
        protected long notBeforeTimeInMillis;
        protected int failedAttempts;
        protected boolean isPriority;

        public MessageEntry(String referenceId, X message, boolean isPriority) {
            this.referenceId = referenceId;
            this.message = message;
            this.isPriority = isPriority;
            this.notBeforeTimeInMillis = 0L;
            this.failedAttempts = 0;
        }
    }
}

