/*
 * Decompiled with CFR 0.152.
 */
package rs.mail.queue;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs.mail.queue.MailQueueListener;

public class MailQueueAdapter
implements MailQueueListener {
    private Logger log;

    public MailQueueAdapter() {
        this(null);
    }

    public MailQueueAdapter(Logger log) {
        this.log = log != null ? log : LoggerFactory.getLogger(this.getClass());
    }

    public Logger getLog() {
        return this.log;
    }

    @Override
    public void onQueued(String referenceId) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Message queued: " + referenceId);
        }
    }

    @Override
    public void onSending(String referenceId) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Message sending: " + referenceId);
        }
    }

    @Override
    public void onSent(String referenceId) {
        if (this.log.isInfoEnabled()) {
            this.log.info("Message sent: " + referenceId);
        }
    }

    @Override
    public void onFailed(String referenceId, int failedAttempts, String reason) {
        this.log.error("Message cannot be sent (" + failedAttempts + "): " + referenceId);
        this.log.error("Reason: " + reason);
    }
}

