/*
 * Decompiled with CFR 0.152.
 */
package rs.data.impl.dao;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs.data.api.DaoFactory;
import rs.data.api.DaoMaster;
import rs.data.api.bo.GeneralBO;
import rs.data.api.dao.GeneralDAO;
import rs.data.event.DaoEvent;
import rs.data.event.DaoListener;
import rs.data.impl.bo.AbstractGeneralBO;
import rs.data.util.CID;
import rs.data.util.DaoIterator;
import rsbaselib.configuration.Configurable;
import rsbaselib.lang.LangUtils;
import rsbaselib.util.RsDate;

public abstract class AbstractGeneralDAO<K extends Serializable, B extends AbstractGeneralBO<K>, C extends GeneralBO<K>>
implements GeneralDAO<K, C>,
Configurable {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private Class<K> keyClass;
    private Class<B> boImplementationClass;
    private Class<C> boInterfaceClass;
    private DaoFactory factory;
    private DaoMaster daoMaster;
    private Map<CID, WeakReference<B>> cache = new WeakHashMap<CID, WeakReference<B>>();
    private Set<DaoListener> listeners = new HashSet<DaoListener>();

    public AbstractGeneralDAO() {
        this.init();
    }

    protected void init() {
        List classes = LangUtils.getTypeArguments(AbstractGeneralDAO.class, this.getClass());
        this.keyClass = (Class)classes.get(0);
        this.boImplementationClass = (Class)classes.get(1);
        this.boInterfaceClass = (Class)classes.get(2);
    }

    public void configure(Configuration cfg) throws ConfigurationException {
    }

    public void beforeConfiguration() {
    }

    public void afterConfiguration() {
    }

    protected Logger getLog() {
        return this.log;
    }

    public Class<K> getKeyClass() {
        return this.keyClass;
    }

    protected Class<B> getBoImplementationClass() {
        return this.boImplementationClass;
    }

    protected Class<C> getBoInterfaceClass() {
        return this.boInterfaceClass;
    }

    @Override
    public DaoFactory getFactory() {
        return this.factory;
    }

    @Override
    public void setFactory(DaoFactory factory) {
        this.factory = factory;
    }

    @Override
    public DaoMaster getDaoMaster() {
        return this.daoMaster;
    }

    @Override
    public void setDaoMaster(DaoMaster daoMaster) {
        this.daoMaster = daoMaster;
    }

    @Override
    public C newInstance() {
        try {
            AbstractGeneralBO rc = (AbstractGeneralBO)this.getBoImplementationClass().newInstance();
            rc.setDao(this);
            this.afterNewInstance(rc);
            return (C)rc;
        }
        catch (IllegalAccessException e) {
            this.log.error("Error creating new object: ", (Throwable)e);
        }
        catch (InstantiationException e) {
            this.log.error("Error creating new object: ", (Throwable)e);
        }
        return null;
    }

    protected void afterNewInstance(C object) {
    }

    protected void addCached(B object) {
        this.cache.put(((AbstractGeneralBO)object).getCID(), new WeakReference<B>(object));
    }

    protected B getCached(CID cid) {
        WeakReference<B> ref = this.cache.get(cid);
        if (ref != null) {
            return (B)((AbstractGeneralBO)ref.get());
        }
        return null;
    }

    @Override
    public void createObject(Object object) {
        this.createObject(object, true);
    }

    @Override
    public void createObject(Object object, boolean setCreationDate) {
        if (!this.getBoInterfaceClass().isInstance(object)) {
            throw new RuntimeException("Cannot create " + object);
        }
        this.create((C)((GeneralBO)object), setCreationDate);
    }

    @Override
    public void create(C object) {
        this.create(object, true);
    }

    @Override
    public void create(C object, boolean setCreationDate) {
        AbstractGeneralBO b = (AbstractGeneralBO)object;
        if (b.getId() != null) {
            throw new RuntimeException("Object already exists: " + object);
        }
        if (setCreationDate) {
            b.setCreationDate(new RsDate());
            b.setChangeDate(new RsDate());
        }
        this.beforeCreate(object);
        this._create(b);
        this.addCached(b);
        this.afterCreate(object);
        this.fireObjectCreated(object);
    }

    protected abstract void _create(B var1);

    protected void beforeCreate(C object) {
    }

    protected void afterCreate(C object) {
        object.setChanged(false);
    }

    @Override
    public List<C> findAll() {
        return this.findAll(-1, -1);
    }

    @Override
    public List<C> findDefaultAll() {
        return this.findDefaultAll(-1, -1);
    }

    @Override
    public DaoIterator<C> iterateAll() {
        return this.iterateAll(-1, -1);
    }

    @Override
    public DaoIterator<C> iterateDefaultAll() {
        return this.iterateDefaultAll(-1, -1);
    }

    @Override
    public void saveObject(Object object) {
        this.saveObject(object, true);
    }

    @Override
    public void saveObject(Object object, boolean setChangeDate) {
        if (!this.getBoInterfaceClass().isInstance(object)) {
            throw new RuntimeException("Cannot save " + object);
        }
        this.save((C)((GeneralBO)object), setChangeDate);
    }

    @Override
    public void save(C object) {
        this.save(object, true);
    }

    @Override
    public void save(C object, boolean setChangeDate) {
        if (object == null) {
            return;
        }
        if (object.isInvalid()) {
            throw new RuntimeException("Cannot save an invalid object");
        }
        AbstractGeneralBO b = (AbstractGeneralBO)object;
        if (b.getId() == null) {
            throw new IllegalStateException("Object was not created yet: " + b);
        }
        if (setChangeDate) {
            b.setChangeDate(new RsDate());
        }
        this.beforeSave(object);
        this._save(b);
        this.afterSave(object);
        this.fireObjectUpdated(object);
    }

    protected void beforeSave(C object) {
    }

    protected void afterSave(C object) {
        object.setChanged(false);
    }

    protected abstract void _save(B var1);

    @Override
    public void deleteObject(Object object) {
        if (!this.getBoInterfaceClass().isInstance(object)) {
            throw new RuntimeException("Cannot delete " + object);
        }
        this.delete((C)((GeneralBO)object));
    }

    @Override
    public void delete(C object) {
        AbstractGeneralBO b = (AbstractGeneralBO)object;
        this.beforeDelete(object);
        this._delete(b);
        this.afterDelete(object);
        this.fireObjectDeleted(object);
    }

    protected void beforeDelete(C object) {
    }

    protected void afterDelete(C object) {
    }

    protected abstract void _delete(B var1);

    @Override
    public void addDaoListener(DaoListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeDaoListener(DaoListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireObjectCreated(C object) {
        this.fireDaoEvent(new DaoEvent(this, DaoEvent.Type.OBJECT_CREATED, (GeneralBO<?>)object));
    }

    protected void fireObjectUpdated(C object) {
        this.fireDaoEvent(new DaoEvent(this, DaoEvent.Type.OBJECT_UPDATED, (GeneralBO<?>)object));
    }

    protected void fireObjectDeleted(C object) {
        this.fireDaoEvent(new DaoEvent(this, DaoEvent.Type.OBJECT_DELETED, (GeneralBO<?>)object));
    }

    protected void fireAllDeleted() {
        this.fireDaoEvent(new DaoEvent(this, DaoEvent.Type.ALL_DELETED));
    }

    protected void fireAllDefaultDeleted() {
        this.fireDaoEvent(new DaoEvent(this, DaoEvent.Type.ALL_DEFAULT_DELETED));
    }

    protected void fireDaoEvent(DaoEvent event) {
        for (DaoListener l : this.listeners) {
            l.handleDaoEvent(event);
        }
    }
}

