/*
 * Decompiled with CFR 0.152.
 */
package rs.data.impl.dao;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import rs.data.api.bo.GeneralBO;
import rs.data.api.dao.GeneralDAO;
import rs.data.impl.bo.AbstractBO;
import rs.data.impl.dao.AbstractGeneralDAO;
import rs.data.impl.dto.GeneralDTO;
import rs.data.util.CID;
import rs.data.util.DaoIterator;
import rsbaselib.lang.LangUtils;

public abstract class AbstractDAO<K extends Serializable, T extends GeneralDTO<K>, B extends AbstractBO<K, T>, C extends GeneralBO<K>>
extends AbstractGeneralDAO<K, B, C>
implements GeneralDAO<K, C> {
    private Class<T> transferClass;

    @Override
    protected void init() {
        super.init();
        List classes = LangUtils.getTypeArguments(AbstractDAO.class, this.getClass());
        this.transferClass = (Class)classes.get(1);
    }

    protected Class<T> getTransferClass() {
        return this.transferClass;
    }

    public C getBusinessObject(T object) {
        if (object == null) {
            return null;
        }
        try {
            CID cid = new CID(this.getBoImplementationClass(), ((GeneralDTO)object).getId());
            AbstractBO cached = (AbstractBO)this.getCached(cid);
            if (cached != null) {
                return (C)cached;
            }
            AbstractBO rc = (AbstractBO)this.getBoImplementationClass().newInstance();
            rc.setDao(this);
            this.afterNewInstance(rc);
            rc.setTransferObject(object);
            this.addCached(rc);
            return (C)rc;
        }
        catch (IllegalAccessException e) {
            this.log.error("Error creating new object: ", (Throwable)e);
        }
        catch (InstantiationException e) {
            this.log.error("Error creating new object: ", (Throwable)e);
        }
        return null;
    }

    protected CID getCID(T object) {
        return new CID(this.getBoImplementationClass(), ((GeneralDTO)object).getId());
    }

    protected void wrap(Collection<C> rc, Collection<T> collection) {
        for (GeneralDTO t : collection) {
            rc.add(this.getBusinessObject(t));
        }
    }

    protected DaoIterator<C> wrap(Iterator<T> i) {
        return new BusinessIterator(i);
    }

    @Override
    protected void _create(B object) {
        Object t = ((AbstractBO)object).getTransferObject();
        this._create((T)t);
    }

    @Override
    protected abstract void _create(T var1);

    @Override
    public C findById(K id) {
        return this.getBusinessObject(this._findById(id));
    }

    protected abstract T _findById(K var1);

    @Override
    public List<C> findAll(int firstResult, int maxResults) {
        List<T> result = this._findAll(firstResult, maxResults);
        ArrayList rc = new ArrayList();
        this.wrap(rc, result);
        return rc;
    }

    protected abstract List<T> _findAll(int var1, int var2);

    @Override
    public List<C> findDefaultAll(int firstResult, int maxResults) {
        List<T> result = this._findDefaultAll(firstResult, maxResults);
        ArrayList rc = new ArrayList();
        this.wrap(rc, result);
        return rc;
    }

    protected abstract List<T> _findDefaultAll(int var1, int var2);

    @Override
    public DaoIterator<C> iterateAll(int firstResult, int maxResults) {
        return this.wrap(this._iterateAll(firstResult, maxResults));
    }

    protected abstract Iterator<T> _iterateAll(int var1, int var2);

    @Override
    public DaoIterator<C> iterateDefaultAll(int firstResult, int maxResults) {
        return this.wrap(this._iterateDefaultAll(firstResult, maxResults));
    }

    protected abstract Iterator<T> _iterateDefaultAll(int var1, int var2);

    @Override
    protected void _save(B object) {
        Object t = ((AbstractBO)object).getTransferObject();
        this._save((T)t);
    }

    @Override
    protected abstract void _save(T var1);

    @Override
    protected void _delete(B object) {
        Object t = ((AbstractBO)object).getTransferObject();
        this._delete((T)t);
    }

    @Override
    protected abstract void _delete(T var1);

    @Override
    public int deleteAll() {
        int rc = this._deleteAll();
        this.fireAllDeleted();
        return rc;
    }

    protected abstract int _deleteAll();

    @Override
    public int deleteDefaultAll() {
        int rc = this._deleteDefaultAll();
        this.fireAllDefaultDeleted();
        return rc;
    }

    protected abstract int _deleteDefaultAll();

    protected class BusinessIterator
    implements DaoIterator<C> {
        private Iterator<T> iterator;

        public BusinessIterator(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            if (this.iterator == null) {
                return false;
            }
            return this.iterator.hasNext();
        }

        @Override
        public C next() {
            if (this.iterator == null) {
                throw new RuntimeException("Empty iterator!");
            }
            return AbstractDAO.this.getBusinessObject((GeneralDTO)this.iterator.next());
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public void close() {
            if (this.iterator instanceof DaoIterator) {
                ((DaoIterator)this.iterator).close();
            }
        }
    }
}

