/*
 * Decompiled with CFR 0.152.
 */
package rs.data.impl.bo;

import java.io.Serializable;
import java.util.List;
import rs.data.impl.bo.AbstractGeneralBO;
import rs.data.impl.dto.GeneralDTO;
import rs.data.util.CID;
import rsbaselib.lang.LangUtils;
import rsbaselib.util.RsDate;

public abstract class AbstractBO<K extends Serializable, T extends GeneralDTO<K>>
extends AbstractGeneralBO<K> {
    private static final long serialVersionUID = 2918149248925033131L;
    private Class<T> transferClass;
    private T transferObject;

    public AbstractBO() {
        this(null);
    }

    public AbstractBO(T transferObject) {
        if (transferObject == null) {
            try {
                transferObject = (GeneralDTO)this.getTransferClass().newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot create empty instance: ", e);
            }
        }
        this.setTransferObject(transferObject);
    }

    @Override
    protected void init() {
        super.init();
        List classes = LangUtils.getTypeArguments(AbstractBO.class, this.getClass());
        this.transferClass = (Class)classes.get(1);
    }

    public Class<T> getTransferClass() {
        return this.transferClass;
    }

    public T getTransferObject() {
        return this.transferObject;
    }

    public void setTransferObject(T transferObject) {
        this.transferObject = transferObject;
        Object id = ((GeneralDTO)transferObject).getId();
        if (id != null) {
            this.setCID(new CID(this.getClass(), id));
        }
    }

    @Override
    public K getId() {
        return ((GeneralDTO)this.getTransferObject()).getId();
    }

    @Override
    public RsDate getCreationDate() {
        return ((GeneralDTO)this.getTransferObject()).getCreationDate();
    }

    @Override
    public void setCreationDate(RsDate creationDate) {
        RsDate oldValue = this.getCreationDate();
        ((GeneralDTO)this.getTransferObject()).setCreationDate(creationDate);
        this.firePropertyChange("creationDate", oldValue, creationDate);
    }

    @Override
    public RsDate getChangeDate() {
        return ((GeneralDTO)this.getTransferObject()).getChangeDate();
    }

    @Override
    public void setChangeDate(RsDate changeDate) {
        RsDate oldValue = this.getChangeDate();
        ((GeneralDTO)this.getTransferObject()).setChangeDate(changeDate);
        this.firePropertyChange("changeDate", oldValue, changeDate);
    }
}

