/*
 * Decompiled with CFR 0.152.
 */
package rs.data.impl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import rs.data.api.DaoFactory;
import rs.data.api.DaoMaster;
import rs.data.util.URLTransformer;
import rsbaselib.configuration.Configurable;
import rsbaselib.io.FileFinder;

public abstract class AbstractDaoMaster
implements DaoMaster,
Configurable {
    private DaoFactory factory;
    private Properties properties = new Properties();

    @Override
    public DaoFactory getFactory() {
        return this.factory;
    }

    @Override
    public void setFactory(DaoFactory factory) {
        this.factory = factory;
    }

    public void configure(Configuration cfg) throws ConfigurationException {
        try {
            String key;
            this.properties = new Properties();
            for (int idx = 0; idx >= 0 && (key = cfg.getString("property(" + idx + ")[@name]")) != null; ++idx) {
                String value = cfg.getString("property(" + idx + ")");
                this.properties.setProperty(key, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void beforeConfiguration() {
    }

    public void afterConfiguration() {
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public URL getPropertyUrl(String key) throws MalformedURLException {
        String value = this.getProperty(key);
        if (value == null) {
            return null;
        }
        URLTransformer transformer = this.getFactory().getUrlTransformer();
        if (transformer != null) {
            return transformer.toURL(value);
        }
        return FileFinder.find((String)value);
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public Iterator<Object> getPropertyKeys() {
        return this.properties.keySet().iterator();
    }
}

