/*
 * Decompiled with CFR 0.152.
 */
package rs.data.impl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs.data.TransactionSupport;
import rs.data.api.DaoFactory;
import rs.data.api.DaoMaster;
import rs.data.api.dao.GeneralDAO;
import rs.data.event.DaoEvent;
import rs.data.event.DaoFactoryEvent;
import rs.data.event.DaoFactoryListener;
import rs.data.event.DaoListener;
import rs.data.util.URLTransformer;
import rsbaselib.configuration.Configurable;
import rsbaselib.configuration.ConfigurationUtils;
import rsbaselib.io.FileFinder;

public abstract class AbstractDaoFactory
implements DaoFactory,
Configurable {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private ThreadLocal<TransactionContext> txContext = new ThreadLocal();
    private Set<DaoFactoryListener> listeners = new HashSet<DaoFactoryListener>();
    private DaoListener daoListener = new MyDaoListener();
    private Map<String, Object> properties = new HashMap<String, Object>();
    private Map<String, String> params = new HashMap<String, String>();
    private TransactionManager txManager;
    private URLTransformer urlTransformer;
    private Map<String, DaoMaster> daoMasters = new HashMap<String, DaoMaster>();

    protected Logger getLog() {
        return this.log;
    }

    public void configure(Configuration cfg) throws ConfigurationException {
        int index = 0;
        while (index >= 0) {
            try {
                String name = cfg.getString("property(" + index + ")[@name]");
                if (name == null) break;
                String value = cfg.getString("property(" + index + ")");
                ++index;
                this.params.put(name, value);
                this.log.debug(name + "=" + value);
            }
            catch (Exception e) {
                index = -1;
            }
        }
        try {
            SubnodeConfiguration tCfg = ((HierarchicalConfiguration)cfg).configurationAt("URLTransformer(0)");
            this.setUrlTransformer((URLTransformer)ConfigurationUtils.load((Configuration)tCfg, (boolean)true));
        }
        catch (Exception e) {
            this.log.info("No URL Transformer loaded");
        }
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.getClass().getClassLoader());
        int index2 = 0;
        while (index2 >= 0) {
            try {
                SubnodeConfiguration tCfg = ((HierarchicalConfiguration)cfg).configurationAt("DaoMaster(" + index2 + ")");
                DaoMaster daoMaster = this.loadDaoMaster(tCfg);
                String id = cfg.getString("DaoMaster(" + index2 + ")[@name]");
                if (id == null) {
                    id = "default";
                }
                this.getLog().debug("DAO Master \"" + id + "\": " + daoMaster.getClass().getName());
                this.setDaoMaster(id, daoMaster);
                ++index2;
            }
            catch (IllegalArgumentException e) {
                index2 = -1;
            }
            catch (Exception e) {
                this.getLog().error("Cannit load DaoMaster: ", (Throwable)e);
                index2 = -1;
            }
        }
        thread.setContextClassLoader(loader);
    }

    public void beforeConfiguration() {
    }

    public void afterConfiguration() {
    }

    public DaoMaster loadDaoMaster(SubnodeConfiguration config) {
        try {
            String className = config.getString("[@class]");
            Class<?> clazz = Class.forName(className);
            DaoMaster rc = (DaoMaster)clazz.newInstance();
            rc.setFactory(this);
            if (rc instanceof Configurable) {
                ((Configurable)rc).configure((Configuration)config);
            }
            return rc;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load class from configuration", e);
        }
    }

    public void setDaoMaster(String id, DaoMaster daoMaster) {
        if (this.daoMasters.containsKey(id)) {
            throw new RuntimeException("DAO Master already exists: " + id);
        }
        this.daoMasters.put(id, daoMaster);
    }

    @Override
    public DaoMaster getDaoMaster(String id) {
        return this.daoMasters.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GeneralDAO<?, ?> createDAO(Configuration mainCfg, String key) throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.getClass().getClassLoader());
        GeneralDAO rc = null;
        try {
            HierarchicalConfiguration hCfg = (HierarchicalConfiguration)mainCfg;
            SubnodeConfiguration cfg = hCfg.configurationAt(key + "(0)");
            String className = cfg.getString("[@class]");
            this.getLog().debug(key + ": " + className);
            Class<?> clazz = Class.forName(className);
            rc = (GeneralDAO)clazz.newInstance();
            rc.setFactory(this);
            String masterId = cfg.getString("[@daoMaster]");
            if (masterId == null) {
                masterId = "default";
            }
            rc.setDaoMaster(this.getDaoMaster(masterId));
            if (rc instanceof Configurable) {
                ((Configurable)rc).configure((Configuration)cfg);
            }
            rc.addDaoListener(this.daoListener);
        }
        finally {
            thread.setContextClassLoader(loader);
        }
        return rc;
    }

    @Override
    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    @Override
    public String getParameter(String name) {
        return this.params.get(name);
    }

    @Override
    public Iterator<String> getParameterKeys() {
        return this.params.keySet().iterator();
    }

    @Override
    public URL getParameterUrl(String name) throws MalformedURLException {
        String value = this.getParameter(name);
        if (value == null) {
            return null;
        }
        URLTransformer transformer = this.getUrlTransformer();
        if (transformer != null) {
            return transformer.toURL(value);
        }
        return FileFinder.find((String)value);
    }

    @Override
    public URLTransformer getUrlTransformer() {
        return this.urlTransformer;
    }

    @Override
    public void setUrlTransformer(URLTransformer urlTransformer) {
        this.urlTransformer = urlTransformer;
    }

    @Override
    public TransactionManager getTransactionManager() {
        if (this.txManager == null) {
            this.setTransactionManager(this.createTransactionManager());
        }
        return this.txManager;
    }

    protected TransactionManager createTransactionManager() {
        try {
            return TransactionSupport.start();
        }
        catch (Throwable t) {
            throw new RuntimeException("Cannot create Transaction Manager", t);
        }
    }

    @Override
    public void setTransactionManager(TransactionManager txManager) {
        if (this.txManager != null) {
            throw new RuntimeException("Transaction Manager already set");
        }
        this.txManager = txManager;
    }

    @Override
    public void begin() {
        TransactionContext context = this.txContext.get();
        if (context == null) {
            context = new TransactionContext();
            this.txContext.set(context);
        }
        context.begin();
    }

    @Override
    public void commit() {
        this.txContext.get().commit();
    }

    @Override
    public void rollback() {
        this.txContext.get().rollback();
    }

    @Override
    public Transaction getTransaction() throws SystemException {
        return this.getTransactionManager().getTransaction();
    }

    @Override
    public void addDaoFactoryListener(DaoFactoryListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeDaoFactoryListener(DaoFactoryListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireDaoFactoryEvent(DaoFactoryEvent event) {
        for (DaoFactoryListener l : this.listeners) {
            l.handleDaoFactoryEvent(event);
        }
    }

    public void modelChanged() {
        TransactionContext context = this.txContext.get();
        if (context != null) {
            context.setModelChanged(true);
        }
    }

    protected class MyDaoListener
    implements DaoListener {
        protected MyDaoListener() {
        }

        @Override
        public void handleDaoEvent(DaoEvent event) {
            AbstractDaoFactory.this.modelChanged();
        }
    }

    protected class TransactionContext {
        private int beginCount = 0;
        private boolean modelChanged = false;

        public void begin() {
            try {
                boolean startTx = true;
                Transaction tx = AbstractDaoFactory.this.getTransaction();
                if (tx != null) {
                    boolean bl = startTx = tx.getStatus() != 0;
                }
                if (startTx) {
                    AbstractDaoFactory.this.getTransactionManager().begin();
                    this.beginCount = 1;
                    this.modelChanged = false;
                    AbstractDaoFactory.this.fireDaoFactoryEvent(new DaoFactoryEvent(AbstractDaoFactory.this, DaoFactoryEvent.Type.TRANSACTION_STARTED));
                } else {
                    ++this.beginCount;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot start TX:", e);
            }
        }

        public void commit() {
            try {
                if (this.beginCount == 1) {
                    if (this.isModelChanged()) {
                        AbstractDaoFactory.this.fireDaoFactoryEvent(new DaoFactoryEvent(AbstractDaoFactory.this, DaoFactoryEvent.Type.MODEL_CHANGED));
                    }
                    AbstractDaoFactory.this.fireDaoFactoryEvent(new DaoFactoryEvent(AbstractDaoFactory.this, DaoFactoryEvent.Type.TRANSACTION_COMMITTING));
                    AbstractDaoFactory.this.getTransaction().commit();
                    AbstractDaoFactory.this.fireDaoFactoryEvent(new DaoFactoryEvent(AbstractDaoFactory.this, DaoFactoryEvent.Type.TRANSACTION_COMMITTED));
                }
                --this.beginCount;
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot commit transaction: ", e);
            }
            if (this.beginCount < 0) {
                throw new RuntimeException("No active transaction found");
            }
        }

        public void rollback() {
            try {
                --this.beginCount;
                if (this.beginCount == 0) {
                    AbstractDaoFactory.this.fireDaoFactoryEvent(new DaoFactoryEvent(AbstractDaoFactory.this, DaoFactoryEvent.Type.TRANSACTION_ROLLING_BACK));
                    AbstractDaoFactory.this.getTransaction().rollback();
                    AbstractDaoFactory.this.fireDaoFactoryEvent(new DaoFactoryEvent(AbstractDaoFactory.this, DaoFactoryEvent.Type.TRANSACTION_ROLLED_BACK));
                } else if (this.beginCount > 0) {
                    AbstractDaoFactory.this.getTransaction().setRollbackOnly();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot rollback transaction: ", e);
            }
            if (this.beginCount < 0) {
                throw new RuntimeException("No active transaction found");
            }
        }

        public boolean isModelChanged() {
            return this.modelChanged;
        }

        public void setModelChanged(boolean modelChanged) {
            this.modelChanged = modelChanged;
        }
    }
}

