/*
 * Decompiled with CFR 0.152.
 */
package csv.util;

import csv.TableReader;
import csv.util.RowConverter;
import java.util.Iterator;

public class ObjectReader<T>
implements Iterator<T>,
Iterable<T> {
    protected TableReader reader;
    protected Iterator<Object[]> iterator;
    protected RowConverter<T> converter;
    private boolean hasHeaderRow;
    protected Object[] tableHeader;

    public ObjectReader(TableReader reader, RowConverter<T> converter, boolean hasHeaderRow) {
        this.reader = reader;
        this.converter = converter;
        this.hasHeaderRow = hasHeaderRow;
        this.tableHeader = null;
        this.iterator = reader.iterator();
        this.readHeaderRow();
    }

    private void readHeaderRow() {
        if (this.hasHeaderRow && this.tableHeader == null && this.reader.hasNext()) {
            this.tableHeader = (Object[])this.reader.next();
        }
    }

    public Object[] getTableHeader() {
        return this.tableHeader;
    }

    public RowConverter<T> getConverter() {
        return this.converter;
    }

    public void setConverter(RowConverter<T> converter) {
        this.converter = converter;
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public T next() {
        return this.converter.convert(this.iterator.next());
    }

    public void close() {
        this.reader.close();
    }
}

