/*
 * Decompiled with CFR 0.152.
 */
package csv.impl.csv.type;

import csv.mapper.TypeConverter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;

public class DateConversionHandler
implements TypeConverter {
    public static final DateConversionHandler INSTANCE = new DateConversionHandler();
    private static final String[] DEFAULT_DATE_FORMATS = new String[]{"dd/MM/yyyy", "dd.MM.yyyy", "dd/MM/yy", "dd.MM.yy", "yyyy/MM/dd", "yyyy.MM.dd"};
    private String[] parsingFormats = null;
    private DateFormat[] parsingFormatters = null;
    private String printFormat = null;
    private DateFormat printFormatter = null;
    private TimeZone timezone = null;

    @Override
    public Class<?>[] getTypes() {
        return new Class[]{Date.class};
    }

    @Override
    public Object fromStream(Object o) {
        DateFormat[] formats;
        if (o == null) {
            return null;
        }
        String s = o.toString().trim();
        for (DateFormat parser : formats = this.getParsingFormatters(s)) {
            try {
                Date rc = parser.parse(s);
                return rc;
            }
            catch (ParseException parseException) {
            }
        }
        return s;
    }

    @Override
    public Object toStream(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Date) {
            return this.getPrintFormatter().format((Date)o);
        }
        return o.toString();
    }

    public DateFormat[] getParsingFormatters() {
        if (this.parsingFormatters == null) {
            String[] formats = this.getParsingFormats();
            this.parsingFormatters = new DateFormat[formats.length];
            for (int i = 0; i < formats.length; ++i) {
                this.parsingFormatters[i] = new SimpleDateFormat(formats[i]);
                this.parsingFormatters[i].setTimeZone(this.getTimezone());
            }
        }
        return this.parsingFormatters;
    }

    protected DateFormat[] getParsingFormatters(String s) {
        DateFormat[] parsers = this.getParsingFormatters();
        ArrayList<DateFormat> rc = new ArrayList<DateFormat>();
        String[] formats = this.getParsingFormats();
        for (int i = 0; i < formats.length; ++i) {
            String format = formats[i];
            if (!this.matches(format, s)) continue;
            rc.add(parsers[i]);
        }
        return rc.toArray(new DateFormat[rc.size()]);
    }

    protected boolean matches(String format, String s) {
        if (format.length() != s.length()) {
            return false;
        }
        for (int i = 0; i < format.length(); ++i) {
            char c1 = format.charAt(i);
            char c2 = s.charAt(i);
            if (Character.isDigit(c2) || Character.isLetter(c2) || c1 == c2) continue;
            return false;
        }
        return true;
    }

    public String[] getParsingFormats() {
        if (this.parsingFormats == null) {
            this.parsingFormats = DEFAULT_DATE_FORMATS;
        }
        return this.parsingFormats;
    }

    public void setParsingFormats(String[] parsingFormats) {
        this.parsingFormats = parsingFormats;
        this.parsingFormatters = null;
        this.printFormatter = null;
    }

    public String getPrintFormat() {
        if (this.printFormat == null) {
            this.printFormat = this.getParsingFormats()[0];
        }
        return this.printFormat;
    }

    public void setPrintFormat(String printFormat) {
        this.printFormat = printFormat;
        this.printFormatter = null;
    }

    public DateFormat getPrintFormatter() {
        if (this.printFormatter == null) {
            this.printFormatter = new SimpleDateFormat(this.getPrintFormat());
            this.printFormatter.setTimeZone(this.getTimezone());
        }
        return this.printFormatter;
    }

    public void setTimezone(TimeZone timezone) {
        this.timezone = timezone;
        if (this.printFormatter != null) {
            this.printFormatter.setTimeZone(timezone);
        }
        if (this.parsingFormatters != null) {
            for (DateFormat format : this.parsingFormatters) {
                format.setTimeZone(timezone);
            }
        }
    }

    public TimeZone getTimezone() {
        if (this.timezone == null) {
            if (this.printFormatter != null) {
                return this.printFormatter.getTimeZone();
            }
            return TimeZone.getDefault();
        }
        return this.timezone;
    }
}

