/*
 * Decompiled with CFR 0.152.
 */
package csv.util;

import csv.CsvException;
import csv.TableWriter;
import csv.util.ObjectConverter;
import csv.util.TableHeaderProvider;
import java.io.IOException;

public class ObjectWriter<T> {
    protected TableWriter writer;
    protected ObjectConverter<T> converter;
    protected TableHeaderProvider headerProvider;
    protected boolean rowsWritten;

    public ObjectWriter(TableWriter writer, ObjectConverter<T> converter) {
        this(writer, converter, null);
    }

    public ObjectWriter(TableWriter writer, ObjectConverter<T> converter, TableHeaderProvider headerProvider) {
        this.writer = writer;
        this.converter = converter;
        if (headerProvider == null && converter instanceof TableHeaderProvider) {
            headerProvider = (TableHeaderProvider)((Object)converter);
        }
        this.headerProvider = headerProvider;
    }

    public ObjectConverter<T> getConverter() {
        return this.converter;
    }

    public void setConverter(ObjectConverter<T> converter) {
        this.converter = converter;
        if (this.headerProvider == null && converter instanceof TableHeaderProvider) {
            this.headerProvider = (TableHeaderProvider)((Object)converter);
        }
    }

    public TableHeaderProvider getHeaderProvider() {
        return this.headerProvider;
    }

    public void setHeaderProvider(TableHeaderProvider headerProvider) {
        this.headerProvider = headerProvider;
    }

    public TableWriter getWriter() {
        return this.writer;
    }

    public void writeHeader(String[] headerRow) {
        if (!this.rowsWritten && headerRow != null) {
            try {
                this.writer.printRow(headerRow);
            }
            catch (IOException e) {
                throw new CsvException("Cannot write to table writer", e);
            }
            this.rowsWritten = true;
        }
    }

    public void write(T[] objects) {
        for (T o : objects) {
            this.write(o);
        }
    }

    public void write(Iterable<? extends T> objects) {
        for (T o : objects) {
            this.write(o);
        }
    }

    public void write(T object) {
        if (object != null) {
            Object[] row = this.converter.convert(object);
            if (!this.rowsWritten) {
                if (this.headerProvider == null && object instanceof TableHeaderProvider) {
                    this.headerProvider = (TableHeaderProvider)object;
                }
                if (this.headerProvider != null) {
                    this.writeHeader(this.headerProvider.getTableHeader());
                }
            }
            try {
                this.writer.printRow(row);
            }
            catch (IOException e) {
                throw new CsvException("Cannot write to table writer", e);
            }
        }
    }

    public void close() {
        this.writer.close();
    }
}

