/*
 * Decompiled with CFR 0.152.
 */
package csv.mapper;

import csv.mapper.MappingCollection;
import csv.mapper.TypeConverter;
import java.util.HashMap;
import java.util.Map;

public class StreamMapper {
    protected Map<Class<?>, TypeConverter> converters = new HashMap();

    public StreamMapper() {
    }

    public StreamMapper(MappingCollection ... collections) {
        for (MappingCollection c : collections) {
            this.add(c);
        }
    }

    public StreamMapper(TypeConverter ... converters) {
        for (TypeConverter c : converters) {
            this.add(c);
        }
    }

    public void add(MappingCollection collection) {
        for (TypeConverter c : collection) {
            this.add(c);
        }
    }

    public void remove(MappingCollection collection) {
        for (TypeConverter c : collection) {
            this.remove(c);
        }
    }

    public void add(TypeConverter converter) {
        for (Class<?> type : converter.getTypes()) {
            this.converters.put(type, converter);
        }
    }

    public void remove(TypeConverter converter) {
        for (Class<?> type : converter.getTypes()) {
            this.converters.remove(type);
        }
    }

    public void remove(Class<?> type) {
        this.converters.remove(type);
    }

    protected TypeConverter getConverter(Class<?> type) {
        return this.converters.get(type);
    }

    public Object toStream(Object value) {
        if (value == null) {
            return null;
        }
        TypeConverter handler = this.getConverter(value.getClass());
        if (handler != null) {
            return handler.toStream(value);
        }
        return value;
    }

    public Object fromStream(Class<?> targetClass, Object value) {
        if (value == null) {
            return null;
        }
        if (targetClass == null) {
            return value;
        }
        TypeConverter handler = this.getConverter(targetClass);
        if (handler != null) {
            return handler.fromStream(value);
        }
        return value;
    }
}

